/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.arrow;

import java.util.Collection;
import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.arrow.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public class ThrownTrident
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.defineId(ThrownTrident.class, EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.defineId(ThrownTrident.class, EntityDataSerializers.BOOLEAN);
    private static final float WATER_INERTIA = 0.99f;
    private static final boolean DEFAULT_DEALT_DAMAGE = false;
    private boolean dealtDamage = false;
    public int clientSideReturnTridentTickCount;

    public ThrownTrident(EntityType<? extends ThrownTrident> entitytypes, Level world) {
        super((EntityType<? extends AbstractArrow>)entitytypes, world);
    }

    public ThrownTrident(Level world, LivingEntity entityliving, ItemStack itemstack) {
        super(EntityType.TRIDENT, entityliving, world, itemstack, null);
        this.entityData.set(ID_LOYALTY, this.getLoyaltyFromItem(itemstack));
        this.entityData.set(ID_FOIL, itemstack.hasFoil());
    }

    public ThrownTrident(Level world, double d0, double d1, double d2, ItemStack itemstack) {
        super(EntityType.TRIDENT, d0, d1, d2, world, itemstack, itemstack);
        this.entityData.set(ID_LOYALTY, this.getLoyaltyFromItem(itemstack));
        this.entityData.set(ID_FOIL, itemstack.hasFoil());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(ID_LOYALTY, (byte)0);
        datawatcher_a.define(ID_FOIL, false);
    }

    @Override
    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.getOwner();
        byte i = this.entityData.get(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.isNoPhysics()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                Level world = this.level();
                if (world instanceof ServerLevel) {
                    ServerLevel worldserver = (ServerLevel)world;
                    if (this.pickup == AbstractArrow.Pickup.ALLOWED) {
                        this.spawnAtLocation(worldserver, this.getPickupItem(), 0.1f);
                    }
                }
                this.discard(EntityRemoveEvent.Cause.DROP);
            } else {
                if (!(entity instanceof Player) && this.position().distanceTo(entity.getEyePosition()) < (double)entity.getBbWidth() + 1.0) {
                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                    return;
                }
                this.setNoPhysics(true);
                Vec3 vec3d = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + vec3d.y * 0.015 * (double)i, this.getZ());
                double d0 = 0.05 * (double)i;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3d.normalize().scale(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.tick();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.getOwner();
        return entity != null && entity.isAlive() ? !(entity instanceof ServerPlayer) || !entity.isSpectator() : false;
    }

    public boolean isFoil() {
        return this.entityData.get(ID_FOIL);
    }

    @Override
    protected @Nullable EntityHitResult findHitEntity(Vec3 vec3d, Vec3 vec3d1) {
        return this.dealtDamage ? null : super.findHitEntity(vec3d, vec3d1);
    }

    @Override
    protected Collection<EntityHitResult> findHitEntities(Vec3 vec3d, Vec3 vec3d1) {
        EntityHitResult movingobjectpositionentity = this.findHitEntity(vec3d, vec3d1);
        return movingobjectpositionentity != null ? List.of(movingobjectpositionentity) : List.of();
    }

    @Override
    protected void onHitEntity(EntityHitResult movingobjectpositionentity) {
        Entity entity = movingobjectpositionentity.getEntity();
        float f = 8.0f;
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().trident(this, entity1 == null ? this : entity1);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            f = EnchantmentHelper.modifyDamage(worldserver, this.getWeaponItem(), entity, damagesource, f);
        }
        this.dealtDamage = true;
        if (entity.hurtOrSimulate(damagesource, f)) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            world = this.level();
            if (world instanceof ServerLevel) {
                ServerLevel worldserver1 = (ServerLevel)world;
                EnchantmentHelper.doPostAttackEffectsWithItemSourceOnBreak(worldserver1, entity, damagesource, this.getWeaponItem(), item -> this.kill(worldserver1));
            }
            if (entity instanceof LivingEntity) {
                LivingEntity entityliving = (LivingEntity)entity;
                this.doKnockback(entityliving, damagesource);
                this.doPostHurtEffects(entityliving);
            }
        }
        this.deflect(ProjectileDeflection.REVERSE, entity, this.owner, false);
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.02, 0.2, 0.02));
        this.playSound(SoundEvents.TRIDENT_HIT, 1.0f, 1.0f);
    }

    @Override
    protected void hitBlockEnchantmentEffects(ServerLevel worldserver, BlockHitResult movingobjectpositionblock, ItemStack itemstack) {
        LivingEntity entityliving1;
        Vec3 vec3d = movingobjectpositionblock.getBlockPos().clampLocationWithin(movingobjectpositionblock.getLocation());
        Entity entity = this.getOwner();
        LivingEntity entityliving = entity instanceof LivingEntity ? (entityliving1 = (LivingEntity)entity) : null;
        EnchantmentHelper.onHitBlock(worldserver, itemstack, entityliving, this, null, vec3d, worldserver.getBlockState(movingobjectpositionblock.getBlockPos()), item -> this.kill(worldserver));
    }

    @Override
    public ItemStack getWeaponItem() {
        return this.getPickupItemStackOrigin();
    }

    @Override
    protected boolean tryPickup(Player entityhuman) {
        return super.tryPickup(entityhuman) || this.isNoPhysics() && this.ownedBy(entityhuman) && entityhuman.getInventory().add(this.getPickupItem());
    }

    @Override
    protected ItemStack getDefaultPickupItem() {
        return new ItemStack(Items.TRIDENT);
    }

    @Override
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    @Override
    public void playerTouch(Player entityhuman) {
        if (this.ownedBy(entityhuman) || this.getOwner() == null) {
            super.playerTouch(entityhuman);
        }
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        this.dealtDamage = valueinput.getBooleanOr("DealtDamage", false);
        this.entityData.set(ID_LOYALTY, this.getLoyaltyFromItem(this.getPickupItemStackOrigin()));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.putBoolean("DealtDamage", this.dealtDamage);
    }

    private byte getLoyaltyFromItem(ItemStack itemstack) {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            return (byte)Mth.clamp(EnchantmentHelper.getTridentReturnToOwnerAcceleration(worldserver, itemstack, this), 0, 127);
        }
        return 0;
    }

    @Override
    public void tickDespawn() {
        byte i = this.entityData.get(ID_LOYALTY);
        if (this.pickup != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.tickDespawn();
        }
    }

    @Override
    protected float getWaterInertia() {
        return 0.99f;
    }

    @Override
    public boolean shouldRender(double d0, double d1, double d2) {
        return true;
    }
}

