/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.hurtingprojectile;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.jspecify.annotations.Nullable;

public abstract class AbstractHurtingProjectile
extends Projectile {
    public static final double INITAL_ACCELERATION_POWER = 0.1;
    public static final double DEFLECTION_SCALE = 0.5;
    public double accelerationPower = 0.1;
    public float bukkitYield = 1.0f;
    public boolean isIncendiary = true;

    protected AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> entitytypes, Level world) {
        super((EntityType<? extends Projectile>)entitytypes, world);
    }

    protected AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> entitytypes, double d0, double d1, double d2, Level world) {
        this(entitytypes, world);
        this.setPos(d0, d1, d2);
    }

    public AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> entitytypes, double d0, double d1, double d2, Vec3 vec3d, Level world) {
        this(entitytypes, world);
        this.snapTo(d0, d1, d2, this.getYRot(), this.getXRot());
        this.reapplyPosition();
        this.assignDirectionalMovement(vec3d, this.accelerationPower);
    }

    public AbstractHurtingProjectile(EntityType<? extends AbstractHurtingProjectile> entitytypes, LivingEntity entityliving, Vec3 vec3d, Level world) {
        this(entitytypes, entityliving.getX(), entityliving.getY(), entityliving.getZ(), vec3d, world);
        this.setOwner(entityliving);
        this.setRot(entityliving.getYRot(), entityliving.getXRot());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double d0) {
        double d1 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d1)) {
            d1 = 4.0;
        }
        return d0 < (d1 *= 64.0) * d1;
    }

    protected ClipContext.Block getClipType() {
        return ClipContext.Block.COLLIDER;
    }

    @Override
    public void tick() {
        Entity entity = this.getOwner();
        this.applyInertia();
        if (this.level().isClientSide() || (entity == null || !entity.isRemoved()) && this.level().hasChunkAt(this.blockPosition())) {
            HitResult movingobjectposition = ProjectileUtil.getHitResultOnMoveVector(this, this::canHitEntity, this.getClipType());
            Vec3 vec3d = movingobjectposition.getType() != HitResult.Type.MISS ? movingobjectposition.getLocation() : this.position().add(this.getDeltaMovement());
            ProjectileUtil.rotateTowardsMovement(this, 0.2f);
            this.setPos(vec3d);
            this.applyEffectsFromBlocks();
            super.tick();
            if (this.shouldBurn()) {
                this.igniteForSeconds(1.0f);
            }
            if (movingobjectposition.getType() != HitResult.Type.MISS && this.isAlive()) {
                this.preHitTargetOrDeflectSelf(movingobjectposition);
            }
            this.createParticleTrail();
        } else {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        }
    }

    private void applyInertia() {
        float f;
        Vec3 vec3d = this.getDeltaMovement();
        Vec3 vec3d1 = this.position();
        if (this.isInWater()) {
            for (int i = 0; i < 4; ++i) {
                float f1 = 0.25f;
                this.level().addParticle(ParticleTypes.BUBBLE, vec3d1.x - vec3d.x * 0.25, vec3d1.y - vec3d.y * 0.25, vec3d1.z - vec3d.z * 0.25, vec3d.x, vec3d.y, vec3d.z);
            }
            f = this.getLiquidInertia();
        } else {
            f = this.getInertia();
        }
        this.setDeltaMovement(vec3d.add(vec3d.normalize().scale(this.accelerationPower)).scale(f));
    }

    private void createParticleTrail() {
        ParticleOptions particleparam = this.getTrailParticle();
        Vec3 vec3d = this.position();
        if (particleparam != null) {
            this.level().addParticle(particleparam, vec3d.x, vec3d.y + 0.5, vec3d.z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        return false;
    }

    @Override
    protected boolean canHitEntity(Entity entity) {
        return super.canHitEntity(entity) && !entity.noPhysics;
    }

    protected boolean shouldBurn() {
        return true;
    }

    protected @Nullable ParticleOptions getTrailParticle() {
        return ParticleTypes.SMOKE;
    }

    protected float getInertia() {
        return 0.95f;
    }

    protected float getLiquidInertia() {
        return 0.8f;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.putDouble("acceleration_power", this.accelerationPower);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        this.accelerationPower = valueinput.getDoubleOr("acceleration_power", 0.1);
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    public void assignDirectionalMovement(Vec3 vec3d, double d0) {
        this.setDeltaMovement(vec3d.normalize().scale(d0));
        this.needsSync = true;
    }

    @Override
    protected void onDeflection(boolean flag) {
        super.onDeflection(flag);
        this.accelerationPower = flag ? 0.1 : (this.accelerationPower *= 0.5);
    }
}

