/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.hurtingprojectile;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.hurtingprojectile.Fireball;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.entity.Explosive;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class LargeFireball
extends Fireball {
    private static final byte DEFAULT_EXPLOSION_POWER = 1;
    public int explosionPower = 1;

    public LargeFireball(EntityType<? extends LargeFireball> entitytypes, Level world) {
        super((EntityType<? extends Fireball>)entitytypes, world);
        ServerLevel worldserver;
        this.isIncendiary = world instanceof ServerLevel && (worldserver = (ServerLevel)world).getGameRules().get(GameRules.MOB_GRIEFING) != false;
    }

    public LargeFireball(Level world, LivingEntity entityliving, Vec3 vec3d, int i) {
        super((EntityType<? extends Fireball>)EntityType.FIREBALL, entityliving, vec3d, world);
        ServerLevel worldserver;
        this.explosionPower = i;
        this.isIncendiary = world instanceof ServerLevel && (worldserver = (ServerLevel)world).getGameRules().get(GameRules.MOB_GRIEFING) != false;
    }

    @Override
    protected void onHit(HitResult movingobjectposition) {
        super.onHit(movingobjectposition);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            boolean flag = worldserver.getGameRules().get(GameRules.MOB_GRIEFING);
            ExplosionPrimeEvent event = new ExplosionPrimeEvent((Explosive)this.getBukkitEntity());
            this.level().getCraftServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), event.getRadius(), event.getFire(), Level.ExplosionInteraction.MOB);
            }
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult movingobjectpositionentity) {
        super.onHitEntity(movingobjectpositionentity);
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            Entity entity = movingobjectpositionentity.getEntity();
            Entity entity1 = this.getOwner();
            DamageSource damagesource = this.damageSources().fireball(this, entity1);
            entity.hurtServer(worldserver, damagesource, 6.0f);
            EnchantmentHelper.doPostAttackEffects(worldserver, entity, damagesource);
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.putByte("ExplosionPower", (byte)this.explosionPower);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        byte by = valueinput.getByteOr("ExplosionPower", (byte)1);
        this.explosionPower = by;
        this.bukkitYield = by;
    }
}

