/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.hurtingprojectile.windcharge;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.entity.projectile.hurtingprojectile.windcharge.AbstractWindCharge;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SimpleExplosionDamageCalculator;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class WindCharge
extends AbstractWindCharge {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new SimpleExplosionDamageCalculator(true, false, Optional.of(Float.valueOf(1.22f)), BuiltInRegistries.BLOCK.get(BlockTags.BLOCKS_WIND_CHARGE_EXPLOSIONS).map(Function.identity()));
    private static final float RADIUS = 1.2f;
    private static final float MIN_CAMERA_DISTANCE_SQUARED = Mth.square(3.5f);
    private int noDeflectTicks = 5;

    public WindCharge(EntityType<? extends AbstractWindCharge> var0, Level var1) {
        super(var0, var1);
    }

    public WindCharge(Player var0, Level var1, double var2, double var4, double var6) {
        super(EntityType.WIND_CHARGE, var1, var0, var2, var4, var6);
    }

    public WindCharge(Level var0, double var1, double var3, double var5, Vec3 var7) {
        super((EntityType<? extends AbstractWindCharge>)EntityType.WIND_CHARGE, var1, var3, var5, var7, var0);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.noDeflectTicks > 0) {
            --this.noDeflectTicks;
        }
    }

    @Override
    public boolean deflect(ProjectileDeflection var0, @Nullable Entity var1, @Nullable EntityReference<Entity> var2, boolean var3) {
        if (this.noDeflectTicks > 0) {
            return false;
        }
        return super.deflect(var0, var1, var2, var3);
    }

    @Override
    public void explode(Vec3 var0) {
        this.level().explode(this, null, EXPLOSION_DAMAGE_CALCULATOR, var0.x(), var0.y(), var0.z(), 1.2f, false, Level.ExplosionInteraction.TRIGGER, ParticleTypes.GUST_EMITTER_SMALL, ParticleTypes.GUST_EMITTER_LARGE, WeightedList.of(), SoundEvents.WIND_CHARGE_BURST);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        if (this.tickCount < 2 && var0 < (double)MIN_CAMERA_DISTANCE_SQUARED) {
            return false;
        }
        return super.shouldRenderAtSqrDistance(var0);
    }
}

