/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.throwableitemprojectile;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.chicken.Chicken;
import net.minecraft.world.entity.projectile.throwableitemprojectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;

public class ThrownEgg
extends ThrowableItemProjectile {
    private static final EntityDimensions ZERO_SIZED_DIMENSIONS = EntityDimensions.fixed(0.0f, 0.0f);

    public ThrownEgg(EntityType<? extends ThrownEgg> entitytypes, Level world) {
        super((EntityType<? extends ThrowableItemProjectile>)entitytypes, world);
    }

    public ThrownEgg(Level world, LivingEntity entityliving, ItemStack itemstack) {
        super(EntityType.EGG, entityliving, world, itemstack);
    }

    public ThrownEgg(Level world, double d0, double d1, double d2, ItemStack itemstack) {
        super(EntityType.EGG, d0, d1, d2, world, itemstack);
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 3) {
            double d0 = 0.08;
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult movingobjectpositionentity) {
        super.onHitEntity(movingobjectpositionentity);
        movingobjectpositionentity.getEntity().hurt(this.damageSources().thrown(this, this.getOwner()), 0.0f);
    }

    @Override
    protected void onHit(HitResult movingobjectposition) {
        super.onHit(movingobjectposition);
        if (!this.level().isClientSide()) {
            boolean hatching = this.random.nextInt(8) == 0;
            int i = 1;
            if (this.random.nextInt(32) == 0) {
                i = 4;
            }
            org.bukkit.entity.EntityType hatchingType = org.bukkit.entity.EntityType.CHICKEN;
            Entity shooter = this.getOwner();
            if (!hatching) {
                i = 0;
            }
            if (shooter instanceof ServerPlayer) {
                PlayerEggThrowEvent event = new PlayerEggThrowEvent((Player)shooter.getBukkitEntity(), (Egg)this.getBukkitEntity(), hatching, (byte)i, hatchingType);
                this.level().getCraftServer().getPluginManager().callEvent((Event)event);
                i = event.getNumHatches();
                hatching = event.isHatching();
                hatchingType = event.getHatchingType();
                if (!hatching) {
                    i = 0;
                }
            }
            for (int j = 0; j < i; ++j) {
                Entity entitychicken = this.level().getWorld().makeEntity(new Location((World)this.level().getWorld(), this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f), hatchingType.getEntityClass());
                if (entitychicken == null) continue;
                if (entitychicken.getBukkitEntity() instanceof Ageable) {
                    ((Ageable)entitychicken.getBukkitEntity()).setBaby();
                }
                entitychicken.snapTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                Optional optional = Optional.ofNullable(this.getItem().get(DataComponents.CHICKEN_VARIANT)).flatMap(eitherholder -> eitherholder.unwrap(this.registryAccess()));
                Objects.requireNonNull(entitychicken);
                if (entitychicken instanceof Chicken) {
                    Chicken chicken = (Chicken)entitychicken;
                    optional.ifPresent(chicken::setVariant);
                }
                if (!entitychicken.fudgePositionAfterSizeChange(ZERO_SIZED_DIMENSIONS)) break;
                this.level().addFreshEntity(entitychicken, CreatureSpawnEvent.SpawnReason.EGG);
            }
            this.level().broadcastEntityEvent(this, (byte)3);
            this.discard(EntityRemoveEvent.Cause.HIT);
        }
    }

    @Override
    protected Item getDefaultItem() {
        return Items.EGG;
    }
}

