/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile.throwableitemprojectile;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.throwableitemprojectile.AbstractThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.entity.LingeringPotionSplashEvent;

public class ThrownLingeringPotion
extends AbstractThrownPotion {
    public ThrownLingeringPotion(EntityType<? extends ThrownLingeringPotion> entitytypes, Level world) {
        super((EntityType<? extends AbstractThrownPotion>)entitytypes, world);
    }

    public ThrownLingeringPotion(Level world, LivingEntity entityliving, ItemStack itemstack) {
        super(EntityType.LINGERING_POTION, world, entityliving, itemstack);
    }

    public ThrownLingeringPotion(Level world, double d0, double d1, double d2, ItemStack itemstack) {
        super(EntityType.LINGERING_POTION, world, d0, d1, d2, itemstack);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.LINGERING_POTION;
    }

    @Override
    public void onHitAsPotion(ServerLevel worldserver, ItemStack itemstack, HitResult movingobjectposition) {
        AreaEffectCloud entityareaeffectcloud = new AreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity entityliving = (LivingEntity)entity;
            entityareaeffectcloud.setOwner(entityliving);
        }
        entityareaeffectcloud.setRadius(3.0f);
        entityareaeffectcloud.setRadiusOnUse(-0.5f);
        entityareaeffectcloud.setDuration(600);
        entityareaeffectcloud.setWaitTime(10);
        entityareaeffectcloud.setRadiusPerTick(-entityareaeffectcloud.getRadius() / (float)entityareaeffectcloud.getDuration());
        entityareaeffectcloud.applyComponentsFromItemStack(itemstack);
        LingeringPotionSplashEvent event = CraftEventFactory.callLingeringPotionSplashEvent(this, movingobjectposition, entityareaeffectcloud);
        if (!event.isCancelled() && !entityareaeffectcloud.isRemoved()) {
            this.level().addFreshEntity(entityareaeffectcloud);
        } else {
            entityareaeffectcloud.discard(null);
        }
    }
}

