/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.SectionPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.raid.RaidStopEvent;
import org.jspecify.annotations.Nullable;

public class Raid {
    public static final SpawnPlacementType RAVAGER_SPAWN_PLACEMENT_TYPE = SpawnPlacements.getPlacementType(EntityType.RAVAGER);
    public static final MapCodec<Raid> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("started").forGetter(raid -> raid.started), (App)Codec.BOOL.fieldOf("active").forGetter(raid -> raid.active), (App)Codec.LONG.fieldOf("ticks_active").forGetter(raid -> raid.ticksActive), (App)Codec.INT.fieldOf("raid_omen_level").forGetter(raid -> raid.raidOmenLevel), (App)Codec.INT.fieldOf("groups_spawned").forGetter(raid -> raid.groupsSpawned), (App)Codec.INT.fieldOf("cooldown_ticks").forGetter(raid -> raid.raidCooldownTicks), (App)Codec.INT.fieldOf("post_raid_ticks").forGetter(raid -> raid.postRaidTicks), (App)Codec.FLOAT.fieldOf("total_health").forGetter(raid -> Float.valueOf(raid.totalHealth)), (App)Codec.INT.fieldOf("group_count").forGetter(raid -> raid.numGroups), (App)RaidStatus.CODEC.fieldOf("status").forGetter(raid -> raid.status), (App)BlockPos.CODEC.fieldOf("center").forGetter(raid -> raid.center), (App)UUIDUtil.CODEC_SET.fieldOf("heroes_of_the_village").forGetter(raid -> raid.heroesOfTheVillage)).apply((Applicative)instance, Raid::new));
    private static final int ALLOW_SPAWNING_WITHIN_VILLAGE_SECONDS_THRESHOLD = 7;
    private static final int SECTION_RADIUS_FOR_FINDING_NEW_VILLAGE_CENTER = 2;
    private static final int VILLAGE_SEARCH_RADIUS = 32;
    private static final int RAID_TIMEOUT_TICKS = 48000;
    private static final int NUM_SPAWN_ATTEMPTS = 5;
    private static final Component OMINOUS_BANNER_PATTERN_NAME = Component.translatable("block.minecraft.ominous_banner");
    private static final String RAIDERS_REMAINING = "event.minecraft.raid.raiders_remaining";
    public static final int VILLAGE_RADIUS_BUFFER = 16;
    private static final int POST_RAID_TICK_LIMIT = 40;
    private static final int DEFAULT_PRE_RAID_TICKS = 300;
    public static final int MAX_NO_ACTION_TIME = 2400;
    public static final int MAX_CELEBRATION_TICKS = 600;
    private static final int OUTSIDE_RAID_BOUNDS_TIMEOUT = 30;
    public static final int DEFAULT_MAX_RAID_OMEN_LEVEL = 5;
    private static final int LOW_MOB_THRESHOLD = 2;
    private static final Component RAID_NAME_COMPONENT = Component.translatable("event.minecraft.raid");
    private static final Component RAID_BAR_VICTORY_COMPONENT = Component.translatable("event.minecraft.raid.victory.full");
    private static final Component RAID_BAR_DEFEAT_COMPONENT = Component.translatable("event.minecraft.raid.defeat.full");
    private static final int HERO_OF_THE_VILLAGE_DURATION = 48000;
    private static final int VALID_RAID_RADIUS = 96;
    public static final int VALID_RAID_RADIUS_SQR = 9216;
    public static final int RAID_REMOVAL_THRESHOLD_SQR = 12544;
    private final Map<Integer, Raider> groupToLeaderMap = Maps.newHashMap();
    private final Map<Integer, Set<Raider>> groupRaiderMap = Maps.newHashMap();
    public final Set<UUID> heroesOfTheVillage = Sets.newHashSet();
    public long ticksActive;
    private BlockPos center;
    private boolean started;
    public float totalHealth;
    public int raidOmenLevel;
    private boolean active;
    private int groupsSpawned;
    private final ServerBossEvent raidEvent = new ServerBossEvent(RAID_NAME_COMPONENT, BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_10);
    private int postRaidTicks;
    private int raidCooldownTicks;
    private final RandomSource random = RandomSource.create();
    public final int numGroups;
    private RaidStatus status;
    private int celebrationTicks;
    private Optional<BlockPos> waveSpawnPos = Optional.empty();

    public Raid(BlockPos blockposition, Difficulty enumdifficulty) {
        this.active = true;
        this.raidCooldownTicks = 300;
        this.raidEvent.setProgress(0.0f);
        this.center = blockposition;
        this.numGroups = this.getNumGroups(enumdifficulty);
        this.status = RaidStatus.ONGOING;
    }

    private Raid(boolean flag, boolean flag1, long i, int j, int k, int l, int i1, float f, int j1, RaidStatus raid_status, BlockPos blockposition, Set<UUID> set) {
        this.started = flag;
        this.active = flag1;
        this.ticksActive = i;
        this.raidOmenLevel = j;
        this.groupsSpawned = k;
        this.raidCooldownTicks = l;
        this.postRaidTicks = i1;
        this.totalHealth = f;
        this.center = blockposition;
        this.numGroups = j1;
        this.status = raid_status;
        this.heroesOfTheVillage.addAll(set);
    }

    public boolean isOver() {
        return this.isVictory() || this.isLoss();
    }

    public boolean isBetweenWaves() {
        return this.hasFirstWaveSpawned() && this.getTotalRaidersAlive() == 0 && this.raidCooldownTicks > 0;
    }

    public boolean hasFirstWaveSpawned() {
        return this.groupsSpawned > 0;
    }

    public boolean isStopped() {
        return this.status == RaidStatus.STOPPED;
    }

    public boolean isVictory() {
        return this.status == RaidStatus.VICTORY;
    }

    public boolean isLoss() {
        return this.status == RaidStatus.LOSS;
    }

    public boolean isInProgress() {
        return this.status == RaidStatus.ONGOING;
    }

    public float getTotalHealth() {
        return this.totalHealth;
    }

    public Set<Raider> getAllRaiders() {
        HashSet set = Sets.newHashSet();
        for (Set<Raider> set1 : this.groupRaiderMap.values()) {
            set.addAll(set1);
        }
        return set;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getGroupsSpawned() {
        return this.groupsSpawned;
    }

    private Predicate<ServerPlayer> validPlayer() {
        return entityplayer -> {
            BlockPos blockposition = entityplayer.blockPosition();
            return entityplayer.isAlive() && entityplayer.level().getRaidAt(blockposition) == this;
        };
    }

    private void updatePlayers(ServerLevel worldserver) {
        HashSet set = Sets.newHashSet(this.raidEvent.getPlayers());
        List<ServerPlayer> list = worldserver.getPlayers(this.validPlayer());
        for (ServerPlayer entityplayer : list) {
            if (set.contains(entityplayer)) continue;
            this.raidEvent.addPlayer(entityplayer);
        }
        for (ServerPlayer entityplayer1 : set) {
            if (list.contains(entityplayer1)) continue;
            this.raidEvent.removePlayer(entityplayer1);
        }
    }

    public int getMaxRaidOmenLevel() {
        return 5;
    }

    public int getRaidOmenLevel() {
        return this.raidOmenLevel;
    }

    public void setRaidOmenLevel(int i) {
        this.raidOmenLevel = i;
    }

    public boolean absorbRaidOmen(ServerPlayer entityplayer) {
        MobEffectInstance mobeffect = entityplayer.getEffect(MobEffects.RAID_OMEN);
        if (mobeffect == null) {
            return false;
        }
        this.raidOmenLevel += mobeffect.getAmplifier() + 1;
        this.raidOmenLevel = Mth.clamp(this.raidOmenLevel, 0, this.getMaxRaidOmenLevel());
        if (!this.hasFirstWaveSpawned()) {
            entityplayer.awardStat(Stats.RAID_TRIGGER);
            CriteriaTriggers.RAID_OMEN.trigger(entityplayer);
        }
        return true;
    }

    public void stop() {
        this.active = false;
        this.raidEvent.removeAllPlayers();
        this.status = RaidStatus.STOPPED;
    }

    public void tick(ServerLevel worldserver) {
        if (!this.isStopped()) {
            if (this.status == RaidStatus.ONGOING) {
                boolean flag = this.active;
                this.active = worldserver.hasChunkAt(this.center);
                if (worldserver.getDifficulty() == Difficulty.PEACEFUL) {
                    CraftEventFactory.callRaidStopEvent(this, worldserver, RaidStopEvent.Reason.PEACE);
                    this.stop();
                    return;
                }
                if (flag != this.active) {
                    this.raidEvent.setVisible(this.active);
                }
                if (!this.active) {
                    return;
                }
                if (!worldserver.isVillage(this.center)) {
                    this.moveRaidCenterToNearbyVillageSection(worldserver);
                }
                if (!worldserver.isVillage(this.center)) {
                    if (this.groupsSpawned > 0) {
                        this.status = RaidStatus.LOSS;
                        CraftEventFactory.callRaidFinishEvent(this, worldserver, new ArrayList<Player>());
                    } else {
                        CraftEventFactory.callRaidStopEvent(this, worldserver, RaidStopEvent.Reason.NOT_IN_VILLAGE);
                        this.stop();
                    }
                }
                ++this.ticksActive;
                if (this.ticksActive >= 48000L) {
                    CraftEventFactory.callRaidStopEvent(this, worldserver, RaidStopEvent.Reason.TIMEOUT);
                    this.stop();
                    return;
                }
                int i = this.getTotalRaidersAlive();
                if (i == 0 && this.hasMoreWaves()) {
                    if (this.raidCooldownTicks <= 0) {
                        if (this.raidCooldownTicks == 0 && this.groupsSpawned > 0) {
                            this.raidCooldownTicks = 300;
                            this.raidEvent.setName(RAID_NAME_COMPONENT);
                            return;
                        }
                    } else {
                        boolean flag2;
                        boolean flag1 = this.waveSpawnPos.isPresent();
                        boolean bl = flag2 = !flag1 && this.raidCooldownTicks % 5 == 0;
                        if (flag1 && !worldserver.isPositionEntityTicking(this.waveSpawnPos.get())) {
                            flag2 = true;
                        }
                        if (flag2) {
                            this.waveSpawnPos = this.getValidSpawnPos(worldserver);
                        }
                        if (this.raidCooldownTicks == 300 || this.raidCooldownTicks % 20 == 0) {
                            this.updatePlayers(worldserver);
                        }
                        --this.raidCooldownTicks;
                        this.raidEvent.setProgress(Mth.clamp((float)(300 - this.raidCooldownTicks) / 300.0f, 0.0f, 1.0f));
                    }
                }
                if (this.ticksActive % 20L == 0L) {
                    this.updatePlayers(worldserver);
                    this.updateRaiders(worldserver);
                    if (i > 0) {
                        if (i <= 2) {
                            this.raidEvent.setName(RAID_NAME_COMPONENT.copy().append(" - ").append(Component.translatable(RAIDERS_REMAINING, i)));
                        } else {
                            this.raidEvent.setName(RAID_NAME_COMPONENT);
                        }
                    } else {
                        this.raidEvent.setName(RAID_NAME_COMPONENT);
                    }
                }
                if (SharedConstants.DEBUG_RAIDS) {
                    ServerBossEvent bossbattleserver = this.raidEvent;
                    MutableComponent ichatmutablecomponent = RAID_NAME_COMPONENT.copy().append(" wave: ").append("" + this.groupsSpawned).append(CommonComponents.SPACE).append("Raiders alive: ").append("" + this.getTotalRaidersAlive()).append(CommonComponents.SPACE).append("" + this.getHealthOfLivingRaiders()).append(" / ").append("" + this.totalHealth).append(" Is bonus? ");
                    boolean flag3 = this.hasBonusWave() && this.hasSpawnedBonusWave();
                    bossbattleserver.setName(ichatmutablecomponent.append("" + flag3).append(" Status: ").append(this.status.getSerializedName()));
                }
                boolean flag4 = false;
                int j = 0;
                while (this.shouldSpawnGroup()) {
                    BlockPos blockposition = this.waveSpawnPos.orElseGet(() -> this.findRandomSpawnPos(worldserver, 20));
                    if (blockposition != null) {
                        this.started = true;
                        this.spawnGroup(worldserver, blockposition);
                        if (!flag4) {
                            this.playSound(worldserver, blockposition);
                            flag4 = true;
                        }
                    } else {
                        ++j;
                    }
                    if (j <= 5) continue;
                    CraftEventFactory.callRaidStopEvent(this, worldserver, RaidStopEvent.Reason.UNSPAWNABLE);
                    this.stop();
                    break;
                }
                if (this.isStarted() && !this.hasMoreWaves() && i == 0) {
                    if (this.postRaidTicks < 40) {
                        ++this.postRaidTicks;
                    } else {
                        this.status = RaidStatus.VICTORY;
                        ArrayList<Player> winners = new ArrayList<Player>();
                        for (UUID uuid : this.heroesOfTheVillage) {
                            Entity entity = worldserver.getEntity(uuid);
                            if (!(entity instanceof LivingEntity)) continue;
                            LivingEntity entityliving = (LivingEntity)entity;
                            if (entity.isSpectator()) continue;
                            entityliving.addEffect(new MobEffectInstance(MobEffects.HERO_OF_THE_VILLAGE, 48000, this.raidOmenLevel - 1, false, false, true));
                            if (!(entityliving instanceof ServerPlayer)) continue;
                            ServerPlayer entityplayer = (ServerPlayer)entityliving;
                            entityplayer.awardStat(Stats.RAID_WIN);
                            CriteriaTriggers.RAID_WIN.trigger(entityplayer);
                            winners.add(entityplayer.getBukkitEntity());
                        }
                        CraftEventFactory.callRaidFinishEvent(this, worldserver, winners);
                    }
                }
                this.setDirty(worldserver);
            } else if (this.isOver()) {
                ++this.celebrationTicks;
                if (this.celebrationTicks >= 600) {
                    CraftEventFactory.callRaidStopEvent(this, worldserver, RaidStopEvent.Reason.FINISHED);
                    this.stop();
                    return;
                }
                if (this.celebrationTicks % 20 == 0) {
                    this.updatePlayers(worldserver);
                    this.raidEvent.setVisible(true);
                    if (this.isVictory()) {
                        this.raidEvent.setProgress(0.0f);
                        this.raidEvent.setName(RAID_BAR_VICTORY_COMPONENT);
                    } else {
                        this.raidEvent.setName(RAID_BAR_DEFEAT_COMPONENT);
                    }
                }
            }
        }
    }

    private void moveRaidCenterToNearbyVillageSection(ServerLevel worldserver) {
        Stream<SectionPos> stream = SectionPos.cube(SectionPos.of(this.center), 2);
        Objects.requireNonNull(worldserver);
        stream.filter(worldserver::isVillage).map(SectionPos::center).min(Comparator.comparingDouble(blockposition -> blockposition.distSqr(this.center))).ifPresent(this::setCenter);
    }

    private Optional<BlockPos> getValidSpawnPos(ServerLevel worldserver) {
        BlockPos blockposition = this.findRandomSpawnPos(worldserver, 8);
        return blockposition != null ? Optional.of(blockposition) : Optional.empty();
    }

    private boolean hasMoreWaves() {
        return this.hasBonusWave() ? !this.hasSpawnedBonusWave() : !this.isFinalWave();
    }

    private boolean isFinalWave() {
        return this.getGroupsSpawned() == this.numGroups;
    }

    private boolean hasBonusWave() {
        return this.raidOmenLevel > 1;
    }

    private boolean hasSpawnedBonusWave() {
        return this.getGroupsSpawned() > this.numGroups;
    }

    private boolean shouldSpawnBonusGroup() {
        return this.isFinalWave() && this.getTotalRaidersAlive() == 0 && this.hasBonusWave();
    }

    private void updateRaiders(ServerLevel worldserver) {
        Iterator<Set<Raider>> iterator = this.groupRaiderMap.values().iterator();
        HashSet set = Sets.newHashSet();
        while (iterator.hasNext()) {
            Set<Raider> set1 = iterator.next();
            for (Raider entityraider : set1) {
                BlockPos blockposition = entityraider.blockPosition();
                if (!entityraider.isRemoved() && entityraider.level().dimension() == worldserver.dimension() && this.center.distSqr(blockposition) < 12544.0) {
                    if (entityraider.tickCount <= 600) continue;
                    if (worldserver.getEntity(entityraider.getUUID()) == null) {
                        set.add(entityraider);
                    }
                    if (!worldserver.isVillage(blockposition) && entityraider.getNoActionTime() > 2400) {
                        entityraider.setTicksOutsideRaid(entityraider.getTicksOutsideRaid() + 1);
                    }
                    if (entityraider.getTicksOutsideRaid() < 30) continue;
                    set.add(entityraider);
                    continue;
                }
                set.add(entityraider);
            }
        }
        for (Raider entityraider1 : set) {
            this.removeFromRaid(worldserver, entityraider1, true);
            if (!entityraider1.isPatrolLeader()) continue;
            this.removeLeader(entityraider1.getWave());
        }
    }

    private void playSound(ServerLevel worldserver, BlockPos blockposition) {
        float f = 13.0f;
        int i = 64;
        Collection<ServerPlayer> collection = this.raidEvent.getPlayers();
        long j = this.random.nextLong();
        for (ServerPlayer entityplayer : worldserver.players()) {
            Vec3 vec3d = entityplayer.position();
            Vec3 vec3d1 = Vec3.atCenterOf(blockposition);
            double d0 = Math.sqrt((vec3d1.x - vec3d.x) * (vec3d1.x - vec3d.x) + (vec3d1.z - vec3d.z) * (vec3d1.z - vec3d.z));
            double d1 = vec3d.x + 13.0 / d0 * (vec3d1.x - vec3d.x);
            double d2 = vec3d.z + 13.0 / d0 * (vec3d1.z - vec3d.z);
            if (!(d0 <= 64.0) && !collection.contains(entityplayer)) continue;
            entityplayer.connection.send(new ClientboundSoundPacket(SoundEvents.RAID_HORN, SoundSource.NEUTRAL, d1, entityplayer.getY(), d2, 64.0f, 1.0f, j));
        }
    }

    private void spawnGroup(ServerLevel worldserver, BlockPos blockposition) {
        boolean flag = false;
        int i = this.groupsSpawned + 1;
        this.totalHealth = 0.0f;
        DifficultyInstance difficultydamagescaler = worldserver.getCurrentDifficultyAt(blockposition);
        boolean flag1 = this.shouldSpawnBonusGroup();
        Raider leader = null;
        ArrayList<Raider> raiders = new ArrayList<Raider>();
        for (RaiderType raid_wave : RaiderType.VALUES) {
            Raider entityraider;
            int j = this.getDefaultNumSpawns(raid_wave, i, flag1) + this.getPotentialBonusSpawns(raid_wave, this.random, i, difficultydamagescaler, flag1);
            int k = 0;
            for (int l = 0; l < j && (entityraider = raid_wave.entityType.create(worldserver, EntitySpawnReason.EVENT)) != null; ++l) {
                if (!flag && entityraider.canBeLeader()) {
                    entityraider.setPatrolLeader(true);
                    this.setLeader(i, entityraider);
                    flag = true;
                    leader = entityraider;
                }
                this.joinRaid(worldserver, i, entityraider, blockposition, false);
                raiders.add(entityraider);
                if (raid_wave.entityType != EntityType.RAVAGER) continue;
                Raider entityraider1 = null;
                if (i == this.getNumGroups(Difficulty.NORMAL)) {
                    entityraider1 = EntityType.PILLAGER.create(worldserver, EntitySpawnReason.EVENT);
                } else if (i >= this.getNumGroups(Difficulty.HARD)) {
                    entityraider1 = k == 0 ? (Raider)EntityType.EVOKER.create(worldserver, EntitySpawnReason.EVENT) : (Raider)EntityType.VINDICATOR.create(worldserver, EntitySpawnReason.EVENT);
                }
                ++k;
                if (entityraider1 == null) continue;
                this.joinRaid(worldserver, i, entityraider1, blockposition, false);
                entityraider1.snapTo(blockposition, 0.0f, 0.0f);
                entityraider1.startRiding(entityraider, false, false);
                raiders.add(entityraider);
            }
        }
        this.waveSpawnPos = Optional.empty();
        ++this.groupsSpawned;
        this.updateBossbar();
        this.setDirty(worldserver);
        CraftEventFactory.callRaidSpawnWaveEvent(this, worldserver, leader, raiders);
    }

    public void joinRaid(ServerLevel worldserver, int i, Raider entityraider, @Nullable BlockPos blockposition, boolean flag) {
        boolean flag1 = this.addWaveMob(worldserver, i, entityraider);
        if (flag1) {
            entityraider.setCurrentRaid(this);
            entityraider.setWave(i);
            entityraider.setCanJoinRaid(true);
            entityraider.setTicksOutsideRaid(0);
            if (!flag && blockposition != null) {
                entityraider.setPos((double)blockposition.getX() + 0.5, (double)blockposition.getY() + 1.0, (double)blockposition.getZ() + 0.5);
                entityraider.finalizeSpawn(worldserver, worldserver.getCurrentDifficultyAt(blockposition), EntitySpawnReason.EVENT, null);
                entityraider.applyRaidBuffs(worldserver, i, false);
                entityraider.setOnGround(true);
                worldserver.addFreshEntityWithPassengers(entityraider, CreatureSpawnEvent.SpawnReason.RAID);
            }
        }
    }

    public void updateBossbar() {
        this.raidEvent.setProgress(Mth.clamp(this.getHealthOfLivingRaiders() / this.totalHealth, 0.0f, 1.0f));
    }

    public float getHealthOfLivingRaiders() {
        float f = 0.0f;
        for (Set<Raider> set : this.groupRaiderMap.values()) {
            for (Raider entityraider : set) {
                f += entityraider.getHealth();
            }
        }
        return f;
    }

    private boolean shouldSpawnGroup() {
        return this.raidCooldownTicks == 0 && (this.groupsSpawned < this.numGroups || this.shouldSpawnBonusGroup()) && this.getTotalRaidersAlive() == 0;
    }

    public int getTotalRaidersAlive() {
        return this.groupRaiderMap.values().stream().mapToInt(Set::size).sum();
    }

    public void removeFromRaid(ServerLevel worldserver, Raider entityraider, boolean flag) {
        boolean flag1;
        Set<Raider> set = this.groupRaiderMap.get(entityraider.getWave());
        if (set != null && (flag1 = set.remove(entityraider))) {
            if (flag) {
                this.totalHealth -= entityraider.getHealth();
            }
            entityraider.setCurrentRaid(null);
            this.updateBossbar();
            this.setDirty(worldserver);
        }
    }

    private void setDirty(ServerLevel worldserver) {
        worldserver.getRaids().setDirty();
    }

    public static ItemStack getOminousBannerInstance(HolderGetter<BannerPattern> holdergetter) {
        ItemStack itemstack = new ItemStack(Items.WHITE_BANNER);
        BannerPatternLayers bannerpatternlayers = new BannerPatternLayers.Builder().addIfRegistered(holdergetter, BannerPatterns.RHOMBUS_MIDDLE, DyeColor.CYAN).addIfRegistered(holdergetter, BannerPatterns.STRIPE_BOTTOM, DyeColor.LIGHT_GRAY).addIfRegistered(holdergetter, BannerPatterns.STRIPE_CENTER, DyeColor.GRAY).addIfRegistered(holdergetter, BannerPatterns.BORDER, DyeColor.LIGHT_GRAY).addIfRegistered(holdergetter, BannerPatterns.STRIPE_MIDDLE, DyeColor.BLACK).addIfRegistered(holdergetter, BannerPatterns.HALF_HORIZONTAL, DyeColor.LIGHT_GRAY).addIfRegistered(holdergetter, BannerPatterns.CIRCLE_MIDDLE, DyeColor.LIGHT_GRAY).addIfRegistered(holdergetter, BannerPatterns.BORDER, DyeColor.BLACK).build();
        itemstack.set(DataComponents.BANNER_PATTERNS, bannerpatternlayers);
        itemstack.set(DataComponents.TOOLTIP_DISPLAY, TooltipDisplay.DEFAULT.withHidden(DataComponents.BANNER_PATTERNS, true));
        itemstack.set(DataComponents.ITEM_NAME, OMINOUS_BANNER_PATTERN_NAME);
        itemstack.set(DataComponents.RARITY, Rarity.UNCOMMON);
        return itemstack;
    }

    public @Nullable Raider getLeader(int i) {
        return this.groupToLeaderMap.get(i);
    }

    private @Nullable BlockPos findRandomSpawnPos(ServerLevel worldserver, int i) {
        int j = this.raidCooldownTicks / 20;
        float f = 0.22f * (float)j - 0.24f;
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        float f1 = worldserver.random.nextFloat() * ((float)Math.PI * 2);
        for (int k = 0; k < i; ++k) {
            int i1;
            float f2 = f1 + (float)Math.PI * (float)k / 8.0f;
            int l = this.center.getX() + Mth.floor(Mth.cos(f2) * 32.0f * f) + worldserver.random.nextInt(3) * Mth.floor(f);
            int j1 = worldserver.getHeight(Heightmap.Types.WORLD_SURFACE, l, i1 = this.center.getZ() + Mth.floor(Mth.sin(f2) * 32.0f * f) + worldserver.random.nextInt(3) * Mth.floor(f));
            if (Mth.abs(j1 - this.center.getY()) > 96) continue;
            blockposition_mutableblockposition.set(l, j1, i1);
            if (worldserver.isVillage(blockposition_mutableblockposition) && j > 7) continue;
            int k1 = 10;
            if (!worldserver.hasChunksAt(blockposition_mutableblockposition.getX() - 10, blockposition_mutableblockposition.getZ() - 10, blockposition_mutableblockposition.getX() + 10, blockposition_mutableblockposition.getZ() + 10) || !worldserver.isPositionEntityTicking(blockposition_mutableblockposition) || !RAVAGER_SPAWN_PLACEMENT_TYPE.isSpawnPositionOk(worldserver, blockposition_mutableblockposition, EntityType.RAVAGER) && (!worldserver.getBlockState((BlockPos)blockposition_mutableblockposition.below()).is(Blocks.SNOW) || !worldserver.getBlockState(blockposition_mutableblockposition).isAir())) continue;
            return blockposition_mutableblockposition;
        }
        return null;
    }

    private boolean addWaveMob(ServerLevel worldserver, int i, Raider entityraider) {
        return this.addWaveMob(worldserver, i, entityraider, true);
    }

    public boolean addWaveMob(ServerLevel worldserver, int i, Raider entityraider, boolean flag) {
        this.groupRaiderMap.computeIfAbsent(i, integer -> Sets.newHashSet());
        Set<Raider> set = this.groupRaiderMap.get(i);
        Raider entityraider1 = null;
        for (Raider entityraider2 : set) {
            if (!entityraider2.getUUID().equals(entityraider.getUUID())) continue;
            entityraider1 = entityraider2;
            break;
        }
        if (entityraider1 != null) {
            set.remove(entityraider1);
            set.add(entityraider);
        }
        set.add(entityraider);
        if (flag) {
            this.totalHealth += entityraider.getHealth();
        }
        this.updateBossbar();
        this.setDirty(worldserver);
        return true;
    }

    public void setLeader(int i, Raider entityraider) {
        this.groupToLeaderMap.put(i, entityraider);
        entityraider.setItemSlot(EquipmentSlot.HEAD, Raid.getOminousBannerInstance(entityraider.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
        entityraider.setDropChance(EquipmentSlot.HEAD, 2.0f);
    }

    public void removeLeader(int i) {
        this.groupToLeaderMap.remove(i);
    }

    public BlockPos getCenter() {
        return this.center;
    }

    private void setCenter(BlockPos blockposition) {
        this.center = blockposition;
    }

    private int getDefaultNumSpawns(RaiderType raid_wave, int i, boolean flag) {
        return flag ? raid_wave.spawnsPerWaveBeforeBonus[this.numGroups] : raid_wave.spawnsPerWaveBeforeBonus[i];
    }

    private int getPotentialBonusSpawns(RaiderType raid_wave, RandomSource randomsource, int i, DifficultyInstance difficultydamagescaler, boolean flag) {
        int j;
        Difficulty enumdifficulty = difficultydamagescaler.getDifficulty();
        boolean flag1 = enumdifficulty == Difficulty.EASY;
        boolean flag2 = enumdifficulty == Difficulty.NORMAL;
        switch (raid_wave.ordinal()) {
            case 0: 
            case 2: {
                if (flag1) {
                    j = randomsource.nextInt(2);
                    break;
                }
                if (flag2) {
                    j = 1;
                    break;
                }
                j = 2;
                break;
            }
            default: {
                return 0;
            }
            case 3: {
                if (flag1 || i <= 2 || i == 4) {
                    return 0;
                }
                j = 1;
                break;
            }
            case 4: {
                j = !flag1 && flag ? 1 : 0;
            }
        }
        return j > 0 ? randomsource.nextInt(j + 1) : 0;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getNumGroups(Difficulty enumdifficulty) {
        return switch (enumdifficulty) {
            case Difficulty.PEACEFUL -> 0;
            case Difficulty.EASY -> 3;
            case Difficulty.NORMAL -> 5;
            case Difficulty.HARD -> 7;
            default -> throw new MatchException(null, null);
        };
    }

    public float getEnchantOdds() {
        int i = this.getRaidOmenLevel();
        return i == 2 ? 0.1f : (i == 3 ? 0.25f : (i == 4 ? 0.5f : (i == 5 ? 0.75f : 0.0f)));
    }

    public void addHeroOfTheVillage(Entity entity) {
        this.heroesOfTheVillage.add(entity.getUUID());
    }

    public Collection<Raider> getRaiders() {
        return this.groupRaiderMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static enum RaidStatus implements StringRepresentable
    {
        ONGOING("ongoing"),
        VICTORY("victory"),
        LOSS("loss"),
        STOPPED("stopped");

        public static final Codec<RaidStatus> CODEC;
        private final String name;

        private RaidStatus(String s) {
            this.name = s;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(RaidStatus::values);
        }
    }

    private static enum RaiderType {
        VINDICATOR(EntityType.VINDICATOR, new int[]{0, 0, 2, 0, 1, 4, 2, 5}),
        EVOKER(EntityType.EVOKER, new int[]{0, 0, 0, 0, 0, 1, 1, 2}),
        PILLAGER(EntityType.PILLAGER, new int[]{0, 4, 3, 3, 4, 4, 4, 2}),
        WITCH(EntityType.WITCH, new int[]{0, 0, 0, 0, 3, 0, 0, 1}),
        RAVAGER(EntityType.RAVAGER, new int[]{0, 0, 0, 1, 0, 1, 0, 2});

        static final RaiderType[] VALUES;
        final EntityType<? extends Raider> entityType;
        final int[] spawnsPerWaveBeforeBonus;

        private RaiderType(EntityType entitytypes, int[] aint) {
            this.entityType = entitytypes;
            this.spawnsPerWaveBeforeBonus = aint;
        }

        static {
            VALUES = RaiderType.values();
        }
    }
}

