/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public interface ContainerEntity
extends Container,
MenuProvider {
    public Vec3 position();

    public AABB getBoundingBox();

    public @Nullable ResourceKey<LootTable> getContainerLootTable();

    public void setContainerLootTable(@Nullable ResourceKey<LootTable> var1);

    public long getContainerLootTableSeed();

    public void setContainerLootTableSeed(long var1);

    public NonNullList<ItemStack> getItemStacks();

    public void clearItemStacks();

    public Level level();

    public boolean isRemoved();

    @Override
    default public boolean isEmpty() {
        return this.isChestVehicleEmpty();
    }

    default public void addChestVehicleSaveData(ValueOutput var0) {
        if (this.getContainerLootTable() != null) {
            var0.putString("LootTable", this.getContainerLootTable().identifier().toString());
            if (this.getContainerLootTableSeed() != 0L) {
                var0.putLong("LootTableSeed", this.getContainerLootTableSeed());
            }
        } else {
            ContainerHelper.saveAllItems(var0, this.getItemStacks());
        }
    }

    default public void readChestVehicleSaveData(ValueInput var0) {
        this.clearItemStacks();
        ResourceKey var1 = var0.read("LootTable", LootTable.KEY_CODEC).orElse(null);
        this.setContainerLootTable(var1);
        this.setContainerLootTableSeed(var0.getLongOr("LootTableSeed", 0L));
        if (var1 == null) {
            ContainerHelper.loadAllItems(var0, this.getItemStacks());
        }
    }

    default public void chestVehicleDestroyed(DamageSource var0, ServerLevel var1, Entity var2) {
        if (!var1.getGameRules().get(GameRules.ENTITY_DROPS).booleanValue()) {
            return;
        }
        Containers.dropContents((Level)var1, var2, (Container)this);
        Entity var3 = var0.getDirectEntity();
        if (var3 != null && var3.getType() == EntityType.PLAYER) {
            PiglinAi.angerNearbyPiglins(var1, (Player)var3, true);
        }
    }

    default public InteractionResult interactWithContainerVehicle(Player var0) {
        var0.openMenu(this);
        return InteractionResult.SUCCESS;
    }

    default public void unpackChestVehicleLootTable(@Nullable Player var0) {
        MinecraftServer var1 = this.level().getServer();
        if (this.getContainerLootTable() != null && var1 != null) {
            LootTable var2 = var1.reloadableRegistries().getLootTable(this.getContainerLootTable());
            if (var0 != null) {
                CriteriaTriggers.GENERATE_LOOT.trigger((ServerPlayer)var0, this.getContainerLootTable());
            }
            this.setContainerLootTable(null);
            LootParams.Builder var3 = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, this.position());
            if (var0 != null) {
                var3.withLuck(var0.getLuck()).withParameter(LootContextParams.THIS_ENTITY, var0);
            }
            var2.fill(this, var3.create(LootContextParamSets.CHEST), this.getContainerLootTableSeed());
        }
    }

    default public void clearChestVehicleContent() {
        this.unpackChestVehicleLootTable(null);
        this.getItemStacks().clear();
    }

    default public boolean isChestVehicleEmpty() {
        for (ItemStack var1 : this.getItemStacks()) {
            if (var1.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack removeChestVehicleItemNoUpdate(int var0) {
        this.unpackChestVehicleLootTable(null);
        ItemStack var1 = this.getItemStacks().get(var0);
        if (var1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.getItemStacks().set(var0, ItemStack.EMPTY);
        return var1;
    }

    default public ItemStack getChestVehicleItem(int var0) {
        this.unpackChestVehicleLootTable(null);
        return this.getItemStacks().get(var0);
    }

    default public ItemStack removeChestVehicleItem(int var0, int var1) {
        this.unpackChestVehicleLootTable(null);
        return ContainerHelper.removeItem(this.getItemStacks(), var0, var1);
    }

    default public void setChestVehicleItem(int var0, ItemStack var1) {
        this.unpackChestVehicleLootTable(null);
        this.getItemStacks().set(var0, var1);
        var1.limitSize(this.getMaxStackSize(var1));
    }

    default public @Nullable SlotAccess getChestVehicleSlot(final int var0) {
        if (var0 >= 0 && var0 < this.getContainerSize()) {
            return new SlotAccess(){

                @Override
                public ItemStack get() {
                    return ContainerEntity.this.getChestVehicleItem(var0);
                }

                @Override
                public boolean set(ItemStack var02) {
                    ContainerEntity.this.setChestVehicleItem(var0, var02);
                    return true;
                }
            };
        }
        return null;
    }

    default public boolean isChestVehicleStillValid(Player var0) {
        return !this.isRemoved() && var0.isWithinEntityInteractionRange(this.getBoundingBox(), 4.0);
    }
}

