/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gamerules.GameRules;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;

public abstract class VehicleEntity
extends Entity {
    protected static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.defineId(VehicleEntity.class, EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.defineId(VehicleEntity.class, EntityDataSerializers.INT);
    protected static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.defineId(VehicleEntity.class, EntityDataSerializers.FLOAT);

    public VehicleEntity(EntityType<?> entitytypes, Level world) {
        super(entitytypes, world);
    }

    @Override
    public boolean hurtClient(DamageSource damagesource) {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        if (this.isRemoved()) {
            return true;
        }
        if (this.isInvulnerableToBase(damagesource)) {
            return false;
        }
        vehicle = (Vehicle)this.getBukkitEntity();
        attacker = damagesource.getEntity() == null ? null : damagesource.getEntity().getBukkitEntity();
        event = new VehicleDamageEvent(vehicle, (org.bukkit.entity.Entity)attacker, (double)f);
        this.level().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        f = (float)event.getDamage();
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.markHurt();
        this.setDamage(this.getDamage() + f * 10.0f);
        this.gameEvent(GameEvent.ENTITY_DAMAGE, damagesource.getEntity());
        entity = damagesource.getEntity();
        if (!(entity instanceof Player)) ** GOTO lbl-1000
        entityhuman = (Player)entity;
        if (entityhuman.getAbilities().instabuild) {
            flag = true;
        } else lbl-1000:
        // 2 sources

        {
            flag = false;
        }
        flag1 = flag;
        if ((flag1 || this.getDamage() <= 40.0f) && !this.shouldSourceDestroy(damagesource)) {
            if (flag1) {
                destroyEvent = new VehicleDestroyEvent(vehicle, (org.bukkit.entity.Entity)attacker);
                this.level().getCraftServer().getPluginManager().callEvent((Event)destroyEvent);
                if (destroyEvent.isCancelled()) {
                    this.setDamage(40.0f);
                    return true;
                }
                this.discard(EntityRemoveEvent.Cause.DEATH);
            }
        } else {
            destroyEvent = new VehicleDestroyEvent(vehicle, (org.bukkit.entity.Entity)attacker);
            this.level().getCraftServer().getPluginManager().callEvent((Event)destroyEvent);
            if (destroyEvent.isCancelled()) {
                this.setDamage(40.0f);
                return true;
            }
            this.destroy(worldserver, damagesource);
        }
        return true;
    }

    protected boolean shouldSourceDestroy(DamageSource damagesource) {
        return false;
    }

    @Override
    public boolean ignoreExplosion(Explosion explosion) {
        return explosion.getIndirectSourceEntity() instanceof Mob && explosion.level().getGameRules().get(GameRules.MOB_GRIEFING) == false;
    }

    public void destroy(ServerLevel worldserver, Item item) {
        this.kill(worldserver);
        if (worldserver.getGameRules().get(GameRules.ENTITY_DROPS).booleanValue()) {
            ItemStack itemstack = new ItemStack(item);
            itemstack.set(DataComponents.CUSTOM_NAME, this.getCustomName());
            this.spawnAtLocation(worldserver, itemstack);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        datawatcher_a.define(DATA_ID_HURT, 0);
        datawatcher_a.define(DATA_ID_HURTDIR, 1);
        datawatcher_a.define(DATA_ID_DAMAGE, Float.valueOf(0.0f));
    }

    public void setHurtTime(int i) {
        this.entityData.set(DATA_ID_HURT, i);
    }

    public void setHurtDir(int i) {
        this.entityData.set(DATA_ID_HURTDIR, i);
    }

    public void setDamage(float f) {
        this.entityData.set(DATA_ID_DAMAGE, Float.valueOf(f));
    }

    public float getDamage() {
        return this.entityData.get(DATA_ID_DAMAGE).floatValue();
    }

    public int getHurtTime() {
        return this.entityData.get(DATA_ID_HURT);
    }

    public int getHurtDir() {
        return this.entityData.get(DATA_ID_HURTDIR);
    }

    protected void destroy(ServerLevel worldserver, DamageSource damagesource) {
        this.destroy(worldserver, this.getDropItem());
    }

    @Override
    public int getDimensionChangingDelay() {
        return 10;
    }

    protected abstract Item getDropItem();
}

