/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle.minecart;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.InterpolationHandler;
import net.minecraft.world.entity.vehicle.minecart.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

public abstract class MinecartBehavior {
    protected final AbstractMinecart minecart;

    protected MinecartBehavior(AbstractMinecart var0) {
        this.minecart = var0;
    }

    public InterpolationHandler getInterpolation() {
        return null;
    }

    public void lerpMotion(Vec3 var0) {
        this.setDeltaMovement(var0);
    }

    public abstract void tick();

    public Level level() {
        return this.minecart.level();
    }

    public abstract void moveAlongTrack(ServerLevel var1);

    public abstract double stepAlongTrack(BlockPos var1, RailShape var2, double var3);

    public abstract boolean pushAndPickupEntities();

    public Vec3 getDeltaMovement() {
        return this.minecart.getDeltaMovement();
    }

    public void setDeltaMovement(Vec3 var0) {
        this.minecart.setDeltaMovement(var0);
    }

    public void setDeltaMovement(double var0, double var2, double var4) {
        this.minecart.setDeltaMovement(var0, var2, var4);
    }

    public Vec3 position() {
        return this.minecart.position();
    }

    public double getX() {
        return this.minecart.getX();
    }

    public double getY() {
        return this.minecart.getY();
    }

    public double getZ() {
        return this.minecart.getZ();
    }

    public void setPos(Vec3 var0) {
        this.minecart.setPos(var0);
    }

    public void setPos(double var0, double var2, double var4) {
        this.minecart.setPos(var0, var2, var4);
    }

    public float getXRot() {
        return this.minecart.getXRot();
    }

    public void setXRot(float var0) {
        this.minecart.setXRot(var0);
    }

    public float getYRot() {
        return this.minecart.getYRot();
    }

    public void setYRot(float var0) {
        this.minecart.setYRot(var0);
    }

    public Direction getMotionDirection() {
        return this.minecart.getDirection();
    }

    public Vec3 getKnownMovement(Vec3 var0) {
        return var0;
    }

    public abstract double getMaxSpeed(ServerLevel var1);

    public abstract double getSlowdownFactor();
}

