/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryView;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public abstract class AbstractMountInventoryMenu
extends AbstractContainerMenu {
    protected final Container mountContainer;
    protected final LivingEntity mount;
    protected final int SLOT_SADDLE = 0;
    protected final int SLOT_BODY_ARMOR = 1;
    protected final int SLOT_INVENTORY_START = 2;
    protected static final int INVENTORY_ROWS = 3;
    CraftInventoryView bukkitEntity;
    net.minecraft.world.entity.player.Inventory player;

    @Override
    public InventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        this.bukkitEntity = new CraftInventoryView<AbstractMountInventoryMenu, Inventory>(this.player.player.getBukkitEntity(), this.mountContainer.getOwner().getInventory(), this);
        return this.bukkitEntity;
    }

    protected AbstractMountInventoryMenu(int i, net.minecraft.world.entity.player.Inventory playerinventory, Container iinventory, LivingEntity entityliving) {
        super(null, i);
        this.player = playerinventory;
        this.mountContainer = iinventory;
        this.mount = entityliving;
        iinventory.startOpen(playerinventory.player);
    }

    protected abstract boolean hasInventoryChanged(Container var1);

    @Override
    public boolean stillValid(Player entityhuman) {
        return !this.hasInventoryChanged(this.mountContainer) && this.mountContainer.stillValid(entityhuman) && this.mount.isAlive() && entityhuman.isWithinEntityInteractionRange(this.mount, 4.0);
    }

    @Override
    public void removed(Player entityhuman) {
        super.removed(entityhuman);
        this.mountContainer.stopOpen(entityhuman);
    }

    @Override
    public ItemStack quickMoveStack(Player entityhuman, int i) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int j = 2 + this.mountContainer.getContainerSize();
            if (i < j) {
                if (!this.moveItemStackTo(itemstack1, j, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(1).mayPlace(itemstack1) && !this.getSlot(1).hasItem()) {
                if (!this.moveItemStackTo(itemstack1, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(0).mayPlace(itemstack1) && !this.getSlot(0).hasItem()) {
                if (!this.moveItemStackTo(itemstack1, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.mountContainer.getContainerSize() == 0 || !this.moveItemStackTo(itemstack1, 2, j, false)) {
                int k = j + 27;
                int l = k + 9;
                if (i >= k && i < l ? !this.moveItemStackTo(itemstack1, j, k, false) : (i >= j && i < k ? !this.moveItemStackTo(itemstack1, k, l, false) : !this.moveItemStackTo(itemstack1, k, k, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public static int getInventorySize(int i) {
        return i * 3;
    }
}

