/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryView;

public class DispenserMenu
extends AbstractContainerMenu {
    private static final int SLOT_COUNT = 9;
    private static final int INV_SLOT_START = 9;
    private static final int INV_SLOT_END = 36;
    private static final int USE_ROW_SLOT_START = 36;
    private static final int USE_ROW_SLOT_END = 45;
    public final Container dispenser;
    private CraftInventoryView bukkitEntity = null;
    private Inventory player;

    public DispenserMenu(int i, Inventory playerinventory) {
        this(i, playerinventory, new SimpleContainer(9));
    }

    public DispenserMenu(int i, Inventory playerinventory, Container iinventory) {
        super(MenuType.GENERIC_3x3, i);
        this.player = playerinventory;
        DispenserMenu.checkContainerSize(iinventory, 9);
        this.dispenser = iinventory;
        iinventory.startOpen(playerinventory.player);
        this.add3x3GridSlots(iinventory, 62, 17);
        this.addStandardInventorySlots(playerinventory, 8, 84);
    }

    protected void add3x3GridSlots(Container iinventory, int i, int j) {
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 3; ++l) {
                int i1 = l + k * 3;
                this.addSlot(new Slot(iinventory, i1, i + l * 18, j + k * 18));
            }
        }
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return this.dispenser.stillValid(entityhuman);
    }

    @Override
    public ItemStack quickMoveStack(Player entityhuman, int i) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i < 9 ? !this.moveItemStackTo(itemstack1, 9, 45, true) : !this.moveItemStackTo(itemstack1, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
        }
        return itemstack;
    }

    @Override
    public void removed(Player entityhuman) {
        super.removed(entityhuman);
        this.dispenser.stopOpen(entityhuman);
    }

    @Override
    public CraftInventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventory inventory = new CraftInventory(this.dispenser);
        this.bukkitEntity = new CraftInventoryView<DispenserMenu, CraftInventory>(this.player.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }
}

