/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Collections;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.gamerules.GameRules;
import org.jspecify.annotations.Nullable;

public interface RecipeCraftingHolder {
    public void setRecipeUsed(@Nullable RecipeHolder<?> var1);

    public @Nullable RecipeHolder<?> getRecipeUsed();

    default public void awardUsedRecipes(Player var0, List<ItemStack> var1) {
        RecipeHolder<?> var2 = this.getRecipeUsed();
        if (var2 != null) {
            var0.triggerRecipeCrafted(var2, var1);
            if (!var2.value().isSpecial()) {
                var0.awardRecipes(Collections.singleton(var2));
                this.setRecipeUsed(null);
            }
        }
    }

    default public boolean setRecipeUsed(ServerPlayer var0, RecipeHolder<?> var1) {
        if (var1.value().isSpecial() || !var0.level().getGameRules().get(GameRules.LIMITED_CRAFTING).booleanValue() || var0.getRecipeBook().contains(var1.id())) {
            this.setRecipeUsed(var1);
            return true;
        }
        return false;
    }
}

