/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.criterion.BlockPredicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.storage.TagValueOutput;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class AdventureModePredicate {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<AdventureModePredicate> CODEC = ExtraCodecs.compactListCodec(BlockPredicate.CODEC, ExtraCodecs.nonEmptyList(BlockPredicate.CODEC.listOf())).xmap(AdventureModePredicate::new, var0 -> var0.predicates);
    public static final StreamCodec<RegistryFriendlyByteBuf, AdventureModePredicate> STREAM_CODEC = StreamCodec.composite(BlockPredicate.STREAM_CODEC.apply(ByteBufCodecs.list()), var0 -> var0.predicates, AdventureModePredicate::new);
    public static final Component CAN_BREAK_HEADER = Component.translatable("item.canBreak").withStyle(ChatFormatting.GRAY);
    public static final Component CAN_PLACE_HEADER = Component.translatable("item.canPlace").withStyle(ChatFormatting.GRAY);
    private static final Component UNKNOWN_USE = Component.translatable("item.canUse.unknown").withStyle(ChatFormatting.GRAY);
    private final List<BlockPredicate> predicates;
    private @Nullable List<Component> cachedTooltip;
    private @Nullable BlockInWorld lastCheckedBlock;
    private boolean lastResult;
    private boolean checksBlockEntity;

    public AdventureModePredicate(List<BlockPredicate> var0) {
        this.predicates = var0;
    }

    private static boolean areSameBlocks(BlockInWorld var0, @Nullable BlockInWorld var1, boolean var2) {
        if (var1 == null || var0.getState() != var1.getState()) {
            return false;
        }
        if (!var2) {
            return true;
        }
        if (var0.getEntity() == null && var1.getEntity() == null) {
            return true;
        }
        if (var0.getEntity() == null || var1.getEntity() == null) {
            return false;
        }
        try (ProblemReporter.ScopedCollector var3 = new ProblemReporter.ScopedCollector(LOGGER);){
            RegistryAccess var4 = var0.getLevel().registryAccess();
            CompoundTag var5 = AdventureModePredicate.saveBlockEntity(var0.getEntity(), var4, var3);
            CompoundTag var6 = AdventureModePredicate.saveBlockEntity(var1.getEntity(), var4, var3);
            boolean bl = Objects.equals(var5, var6);
            return bl;
        }
    }

    private static CompoundTag saveBlockEntity(BlockEntity var0, RegistryAccess var1, ProblemReporter var2) {
        TagValueOutput var3 = TagValueOutput.createWithContext(var2.forChild(var0.problemPath()), var1);
        var0.saveWithId(var3);
        return var3.buildResult();
    }

    public boolean test(BlockInWorld var0) {
        if (AdventureModePredicate.areSameBlocks(var0, this.lastCheckedBlock, this.checksBlockEntity)) {
            return this.lastResult;
        }
        this.lastCheckedBlock = var0;
        this.checksBlockEntity = false;
        for (BlockPredicate var2 : this.predicates) {
            if (!var2.matches(var0)) continue;
            this.checksBlockEntity |= var2.requiresNbt();
            this.lastResult = true;
            return true;
        }
        this.lastResult = false;
        return false;
    }

    private List<Component> tooltip() {
        if (this.cachedTooltip == null) {
            this.cachedTooltip = AdventureModePredicate.computeTooltip(this.predicates);
        }
        return this.cachedTooltip;
    }

    public void addToTooltip(Consumer<Component> var0) {
        this.tooltip().forEach(var0);
    }

    private static List<Component> computeTooltip(List<BlockPredicate> var02) {
        for (BlockPredicate var2 : var02) {
            if (!var2.blocks().isEmpty()) continue;
            return List.of(UNKNOWN_USE);
        }
        return var02.stream().flatMap(var0 -> var0.blocks().orElseThrow().stream()).distinct().map(var0 -> ((Block)var0.value()).getName().withStyle(ChatFormatting.DARK_GRAY)).toList();
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof AdventureModePredicate) {
            AdventureModePredicate var1 = (AdventureModePredicate)var0;
            return this.predicates.equals(var1.predicates);
        }
        return false;
    }

    public int hashCode() {
        return this.predicates.hashCode();
    }

    public String toString() {
        return "AdventureModePredicate{predicates=" + String.valueOf(this.predicates) + "}";
    }
}

