/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.jspecify.annotations.Nullable;

public class BoatItem
extends Item {
    private final EntityType<? extends AbstractBoat> entityType;

    public BoatItem(EntityType<? extends AbstractBoat> entitytypes, Item.Properties item_info) {
        super(item_info);
        this.entityType = entitytypes;
    }

    @Override
    public InteractionResult use(Level world, Player entityhuman, InteractionHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        BlockHitResult movingobjectposition = BoatItem.getPlayerPOVHitResult(world, entityhuman, ClipContext.Fluid.ANY);
        if (movingobjectposition.getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        Vec3 vec3d = entityhuman.getViewVector(1.0f);
        double d0 = 5.0;
        List<Entity> list = world.getEntities(entityhuman, entityhuman.getBoundingBox().expandTowards(vec3d.scale(5.0)).inflate(1.0), EntitySelector.CAN_BE_PICKED);
        if (!list.isEmpty()) {
            Vec3 vec3d1 = entityhuman.getEyePosition();
            for (Entity entity : list) {
                AABB axisalignedbb = entity.getBoundingBox().inflate(entity.getPickRadius());
                if (!axisalignedbb.contains(vec3d1)) continue;
                return InteractionResult.PASS;
            }
        }
        if (movingobjectposition.getType() == HitResult.Type.BLOCK) {
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(entityhuman, Action.RIGHT_CLICK_BLOCK, movingobjectposition.getBlockPos(), movingobjectposition.getDirection(), itemstack, false, enumhand, movingobjectposition.getLocation());
            if (event.isCancelled()) {
                return InteractionResult.PASS;
            }
            AbstractBoat abstractboat = this.getBoat(world, movingobjectposition, itemstack, entityhuman);
            if (abstractboat == null) {
                return InteractionResult.FAIL;
            }
            abstractboat.setYRot(entityhuman.getYRot());
            if (!world.noCollision(abstractboat, abstractboat.getBoundingBox())) {
                return InteractionResult.FAIL;
            }
            if (!world.isClientSide()) {
                if (CraftEventFactory.callEntityPlaceEvent(world, movingobjectposition.getBlockPos(), movingobjectposition.getDirection(), entityhuman, abstractboat, enumhand).isCancelled()) {
                    return InteractionResult.FAIL;
                }
                if (!world.addFreshEntity(abstractboat)) {
                    return InteractionResult.PASS;
                }
                world.gameEvent((Entity)entityhuman, GameEvent.ENTITY_PLACE, movingobjectposition.getLocation());
                itemstack.consume(1, entityhuman);
            }
            entityhuman.awardStat(Stats.ITEM_USED.get(this));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private @Nullable AbstractBoat getBoat(Level world, HitResult movingobjectposition, ItemStack itemstack, Player entityhuman) {
        AbstractBoat abstractboat = this.entityType.create(world, EntitySpawnReason.SPAWN_ITEM_USE);
        if (abstractboat != null) {
            Vec3 vec3d = movingobjectposition.getLocation();
            abstractboat.setInitialPos(vec3d.x, vec3d.y, vec3d.z);
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                EntityType.createDefaultStackConfig(worldserver, itemstack, entityhuman).accept(abstractboat);
            }
        }
        return abstractboat;
    }
}

