/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jspecify.annotations.Nullable;

public class CompassItem
extends Item {
    private static final Component LODESTONE_COMPASS_NAME = Component.translatable("item.minecraft.lodestone_compass");

    public CompassItem(Item.Properties var0) {
        super(var0);
    }

    @Override
    public boolean isFoil(ItemStack var0) {
        return var0.has(DataComponents.LODESTONE_TRACKER) || super.isFoil(var0);
    }

    @Override
    public void inventoryTick(ItemStack var0, ServerLevel var1, Entity var2, @Nullable EquipmentSlot var3) {
        LodestoneTracker var5;
        LodestoneTracker var4 = var0.get(DataComponents.LODESTONE_TRACKER);
        if (var4 != null && (var5 = var4.tick(var1)) != var4) {
            var0.set(DataComponents.LODESTONE_TRACKER, var5);
        }
    }

    @Override
    public InteractionResult useOn(UseOnContext var0) {
        BlockPos var1 = var0.getClickedPos();
        Level var2 = var0.getLevel();
        if (var2.getBlockState(var1).is(Blocks.LODESTONE)) {
            var2.playSound(null, var1, SoundEvents.LODESTONE_COMPASS_LOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
            Player var3 = var0.getPlayer();
            ItemStack var4 = var0.getItemInHand();
            boolean var5 = !var3.hasInfiniteMaterials() && var4.getCount() == 1;
            LodestoneTracker var6 = new LodestoneTracker(Optional.of(GlobalPos.of(var2.dimension(), var1)), true);
            if (var5) {
                var4.set(DataComponents.LODESTONE_TRACKER, var6);
            } else {
                ItemStack var7 = var4.transmuteCopy(Items.COMPASS, 1);
                var4.consume(1, var3);
                var7.set(DataComponents.LODESTONE_TRACKER, var6);
                if (!var3.getInventory().add(var7)) {
                    var3.drop(var7, false);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(var0);
    }

    @Override
    public Component getName(ItemStack var0) {
        return var0.has(DataComponents.LODESTONE_TRACKER) ? LODESTONE_COMPASS_NAME : super.getName(var0);
    }
}

