/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.level.ItemLike;
import org.jspecify.annotations.Nullable;

public class CreativeModeTab {
    static final Identifier DEFAULT_BACKGROUND = CreativeModeTab.createTextureLocation("items");
    private final Component displayName;
    Identifier backgroundTexture = DEFAULT_BACKGROUND;
    boolean canScroll = true;
    boolean showTitle = true;
    boolean alignedRight = false;
    private final Row row;
    private final int column;
    private final Type type;
    private @Nullable ItemStack iconItemStack;
    private Collection<ItemStack> displayItems = ItemStackLinkedSet.createTypeAndComponentsSet();
    private Set<ItemStack> displayItemsSearchTab = ItemStackLinkedSet.createTypeAndComponentsSet();
    private final Supplier<ItemStack> iconGenerator;
    private final DisplayItemsGenerator displayItemsGenerator;

    CreativeModeTab(Row var0, int var1, Type var2, Component var3, Supplier<ItemStack> var4, DisplayItemsGenerator var5) {
        this.row = var0;
        this.column = var1;
        this.displayName = var3;
        this.iconGenerator = var4;
        this.displayItemsGenerator = var5;
        this.type = var2;
    }

    public static Identifier createTextureLocation(String var0) {
        return Identifier.withDefaultNamespace("textures/gui/container/creative_inventory/tab_" + var0 + ".png");
    }

    public static Builder builder(Row var0, int var1) {
        return new Builder(var0, var1);
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public ItemStack getIconItem() {
        if (this.iconItemStack == null) {
            this.iconItemStack = this.iconGenerator.get();
        }
        return this.iconItemStack;
    }

    public Identifier getBackgroundTexture() {
        return this.backgroundTexture;
    }

    public boolean showTitle() {
        return this.showTitle;
    }

    public boolean canScroll() {
        return this.canScroll;
    }

    public int column() {
        return this.column;
    }

    public Row row() {
        return this.row;
    }

    public boolean hasAnyItems() {
        return !this.displayItems.isEmpty();
    }

    public boolean shouldDisplay() {
        return this.type != Type.CATEGORY || this.hasAnyItems();
    }

    public boolean isAlignedRight() {
        return this.alignedRight;
    }

    public Type getType() {
        return this.type;
    }

    public void buildContents(ItemDisplayParameters var0) {
        ItemDisplayBuilder var1 = new ItemDisplayBuilder(this, var0.enabledFeatures);
        ResourceKey<CreativeModeTab> var2 = BuiltInRegistries.CREATIVE_MODE_TAB.getResourceKey(this).orElseThrow(() -> new IllegalStateException("Unregistered creative tab: " + String.valueOf(this)));
        this.displayItemsGenerator.accept(var0, var1);
        this.displayItems = var1.tabContents;
        this.displayItemsSearchTab = var1.searchTabContents;
    }

    public Collection<ItemStack> getDisplayItems() {
        return this.displayItems;
    }

    public Collection<ItemStack> getSearchTabDisplayItems() {
        return this.displayItemsSearchTab;
    }

    public boolean contains(ItemStack var0) {
        return this.displayItemsSearchTab.contains(var0);
    }

    public static enum Row {
        TOP,
        BOTTOM;

    }

    @FunctionalInterface
    public static interface DisplayItemsGenerator {
        public void accept(ItemDisplayParameters var1, Output var2);
    }

    public static enum Type {
        CATEGORY,
        INVENTORY,
        HOTBAR,
        SEARCH;

    }

    public static class Builder {
        private static final DisplayItemsGenerator EMPTY_GENERATOR = (var0, var1) -> {};
        private final Row row;
        private final int column;
        private Component displayName = Component.empty();
        private Supplier<ItemStack> iconGenerator = () -> ItemStack.EMPTY;
        private DisplayItemsGenerator displayItemsGenerator = EMPTY_GENERATOR;
        private boolean canScroll = true;
        private boolean showTitle = true;
        private boolean alignedRight = false;
        private Type type = Type.CATEGORY;
        private Identifier backgroundTexture = DEFAULT_BACKGROUND;

        public Builder(Row var0, int var1) {
            this.row = var0;
            this.column = var1;
        }

        public Builder title(Component var0) {
            this.displayName = var0;
            return this;
        }

        public Builder icon(Supplier<ItemStack> var0) {
            this.iconGenerator = var0;
            return this;
        }

        public Builder displayItems(DisplayItemsGenerator var0) {
            this.displayItemsGenerator = var0;
            return this;
        }

        public Builder alignedRight() {
            this.alignedRight = true;
            return this;
        }

        public Builder hideTitle() {
            this.showTitle = false;
            return this;
        }

        public Builder noScrollBar() {
            this.canScroll = false;
            return this;
        }

        protected Builder type(Type var0) {
            this.type = var0;
            return this;
        }

        public Builder backgroundTexture(Identifier var0) {
            this.backgroundTexture = var0;
            return this;
        }

        public CreativeModeTab build() {
            if ((this.type == Type.HOTBAR || this.type == Type.INVENTORY) && this.displayItemsGenerator != EMPTY_GENERATOR) {
                throw new IllegalStateException("Special tabs can't have display items");
            }
            CreativeModeTab var0 = new CreativeModeTab(this.row, this.column, this.type, this.displayName, this.iconGenerator, this.displayItemsGenerator);
            var0.alignedRight = this.alignedRight;
            var0.showTitle = this.showTitle;
            var0.canScroll = this.canScroll;
            var0.backgroundTexture = this.backgroundTexture;
            return var0;
        }
    }

    static class ItemDisplayBuilder
    implements Output {
        public final Collection<ItemStack> tabContents = ItemStackLinkedSet.createTypeAndComponentsSet();
        public final Set<ItemStack> searchTabContents = ItemStackLinkedSet.createTypeAndComponentsSet();
        private final CreativeModeTab tab;
        private final FeatureFlagSet featureFlagSet;

        public ItemDisplayBuilder(CreativeModeTab var0, FeatureFlagSet var1) {
            this.tab = var0;
            this.featureFlagSet = var1;
        }

        @Override
        public void accept(ItemStack var0, TabVisibility var1) {
            boolean var2;
            if (var0.getCount() != 1) {
                throw new IllegalArgumentException("Stack size must be exactly 1");
            }
            boolean bl = var2 = this.tabContents.contains(var0) && var1 != TabVisibility.SEARCH_TAB_ONLY;
            if (var2) {
                throw new IllegalStateException("Accidentally adding the same item stack twice " + var0.getDisplayName().getString() + " to a Creative Mode Tab: " + this.tab.getDisplayName().getString());
            }
            if (var0.getItem().isEnabled(this.featureFlagSet)) {
                switch (var1.ordinal()) {
                    case 0: {
                        this.tabContents.add(var0);
                        this.searchTabContents.add(var0);
                        break;
                    }
                    case 1: {
                        this.tabContents.add(var0);
                        break;
                    }
                    case 2: {
                        this.searchTabContents.add(var0);
                    }
                }
            }
        }
    }

    public static final class ItemDisplayParameters
    extends Record {
        final FeatureFlagSet enabledFeatures;
        private final boolean hasPermissions;
        private final HolderLookup.Provider holders;

        public ItemDisplayParameters(FeatureFlagSet var0, boolean var1, HolderLookup.Provider var2) {
            this.enabledFeatures = var0;
            this.hasPermissions = var1;
            this.holders = var2;
        }

        public boolean needsUpdate(FeatureFlagSet var0, boolean var1, HolderLookup.Provider var2) {
            return !this.enabledFeatures.equals(var0) || this.hasPermissions != var1 || this.holders != var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ItemDisplayParameters.class, "enabledFeatures;hasPermissions;holders", "enabledFeatures", "hasPermissions", "holders"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ItemDisplayParameters.class, "enabledFeatures;hasPermissions;holders", "enabledFeatures", "hasPermissions", "holders"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ItemDisplayParameters.class, "enabledFeatures;hasPermissions;holders", "enabledFeatures", "hasPermissions", "holders"}, this, var0);
        }

        public FeatureFlagSet enabledFeatures() {
            return this.enabledFeatures;
        }

        public boolean hasPermissions() {
            return this.hasPermissions;
        }

        public HolderLookup.Provider holders() {
            return this.holders;
        }
    }

    public static interface Output {
        public void accept(ItemStack var1, TabVisibility var2);

        default public void accept(ItemStack var0) {
            this.accept(var0, TabVisibility.PARENT_AND_SEARCH_TABS);
        }

        default public void accept(ItemLike var0, TabVisibility var1) {
            this.accept(new ItemStack(var0), var1);
        }

        default public void accept(ItemLike var0) {
            this.accept(new ItemStack(var0), TabVisibility.PARENT_AND_SEARCH_TABS);
        }

        default public void acceptAll(Collection<ItemStack> var0, TabVisibility var12) {
            var0.forEach(var1 -> this.accept((ItemStack)var1, var12));
        }

        default public void acceptAll(Collection<ItemStack> var0) {
            this.acceptAll(var0, TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    protected static enum TabVisibility {
        PARENT_AND_SEARCH_TABS,
        PARENT_TAB_ONLY,
        SEARCH_TAB_ONLY;

    }
}

