/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.SheepDyeWoolEvent;

public class DyeItem
extends Item
implements SignApplicator {
    private static final Map<DyeColor, DyeItem> ITEM_BY_COLOR = Maps.newEnumMap(DyeColor.class);
    private final DyeColor dyeColor;

    public DyeItem(DyeColor enumcolor, Item.Properties item_info) {
        super(item_info);
        this.dyeColor = enumcolor;
        ITEM_BY_COLOR.put(enumcolor, this);
    }

    @Override
    public InteractionResult interactLivingEntity(ItemStack itemstack, Player entityhuman, LivingEntity entityliving, InteractionHand enumhand) {
        Sheep entitysheep;
        if (entityliving instanceof Sheep && (entitysheep = (Sheep)entityliving).isAlive() && !entitysheep.isSheared() && entitysheep.getColor() != this.dyeColor) {
            entitysheep.level().playSound((Entity)entityhuman, entitysheep, SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!entityhuman.level().isClientSide()) {
                byte bColor = (byte)this.dyeColor.getId();
                SheepDyeWoolEvent event = new SheepDyeWoolEvent((org.bukkit.entity.Sheep)entitysheep.getBukkitEntity(), org.bukkit.DyeColor.getByWoolData((byte)bColor), (org.bukkit.entity.Player)entityhuman.getBukkitEntity());
                entitysheep.level().getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return InteractionResult.PASS;
                }
                entitysheep.setColor(DyeColor.byId(event.getColor().getWoolData()));
                itemstack.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public static DyeItem byColor(DyeColor enumcolor) {
        return ITEM_BY_COLOR.get(enumcolor);
    }

    @Override
    public boolean tryApplyToSign(Level world, SignBlockEntity tileentitysign, boolean flag, Player entityhuman) {
        if (tileentitysign.updateText(signtext -> signtext.setColor(this.getDyeColor()), flag)) {
            world.playSound((Entity)null, tileentitysign.getBlockPos(), SoundEvents.DYE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }
}

