/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.v1_21_R7.CraftEquipmentSlot;
import org.bukkit.entity.FishHook;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerFishEvent;

public class FishingRodItem
extends Item {
    public FishingRodItem(Item.Properties item_info) {
        super(item_info);
    }

    @Override
    public InteractionResult use(Level world, Player entityhuman, InteractionHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (entityhuman.fishing != null) {
            if (!world.isClientSide()) {
                int i = entityhuman.fishing.retrieve(itemstack);
                itemstack.hurtAndBreak(i, (LivingEntity)entityhuman, enumhand.asEquipmentSlot());
            }
            world.playSound((Entity)null, entityhuman.getX(), entityhuman.getY(), entityhuman.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
            itemstack.causeUseVibration(entityhuman, GameEvent.ITEM_INTERACT_FINISH);
        } else {
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                int j = (int)(EnchantmentHelper.getFishingTimeReduction(worldserver, itemstack, entityhuman) * 20.0f);
                int k = EnchantmentHelper.getFishingLuckBonus(worldserver, itemstack, entityhuman);
                FishingHook entityfishinghook = new FishingHook(entityhuman, world, k, j);
                PlayerFishEvent playerFishEvent = new PlayerFishEvent((org.bukkit.entity.Player)entityhuman.getBukkitEntity(), null, (FishHook)entityfishinghook.getBukkitEntity(), CraftEquipmentSlot.getHand(enumhand), PlayerFishEvent.State.FISHING);
                world.getCraftServer().getPluginManager().callEvent((Event)playerFishEvent);
                if (playerFishEvent.isCancelled()) {
                    entityhuman.fishing = null;
                    return InteractionResult.PASS;
                }
                world.playSound((Entity)null, entityhuman.getX(), entityhuman.getY(), entityhuman.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
                Projectile.spawnProjectile(entityfishinghook, worldserver, itemstack);
            }
            entityhuman.awardStat(Stats.ITEM_USED.get(this));
            itemstack.causeUseVibration(entityhuman, GameEvent.ITEM_INTERACT_START);
        }
        return InteractionResult.SUCCESS;
    }
}

