/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.throwableitemprojectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;

public class SnowballItem
extends Item
implements ProjectileItem {
    public static float PROJECTILE_SHOOT_POWER = 1.5f;

    public SnowballItem(Item.Properties item_info) {
        super(item_info);
    }

    @Override
    public InteractionResult use(Level world, Player entityhuman, InteractionHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (Projectile.spawnProjectileFromRotation(Snowball::new, worldserver, itemstack, entityhuman, 0.0f, PROJECTILE_SHOOT_POWER, 1.0f).isAlive()) {
                itemstack.consume(1, entityhuman);
                world.playSound((Entity)null, entityhuman.getX(), entityhuman.getY(), entityhuman.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.getRandom().nextFloat() * 0.4f + 0.8f));
            } else if (entityhuman instanceof ServerPlayer) {
                ((ServerPlayer)entityhuman).getBukkitEntity().updateInventory();
            }
        }
        entityhuman.awardStat(Stats.ITEM_USED.get(this));
        return InteractionResult.SUCCESS;
    }

    @Override
    public Projectile asProjectile(Level world, Position iposition, ItemStack itemstack, Direction enumdirection) {
        return new Snowball(world, iposition.x(), iposition.y(), iposition.z(), itemstack);
    }
}

