/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public record AttackRange(float minRange, float maxRange, float minCreativeRange, float maxCreativeRange, float hitboxMargin, float mobFactor) {
    public static final Codec<AttackRange> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.floatRange(0.0f, 64.0f).optionalFieldOf("min_reach", (Object)Float.valueOf(0.0f)).forGetter(AttackRange::minRange), (App)ExtraCodecs.floatRange(0.0f, 64.0f).optionalFieldOf("max_reach", (Object)Float.valueOf(3.0f)).forGetter(AttackRange::maxRange), (App)ExtraCodecs.floatRange(0.0f, 64.0f).optionalFieldOf("min_creative_reach", (Object)Float.valueOf(0.0f)).forGetter(AttackRange::minCreativeRange), (App)ExtraCodecs.floatRange(0.0f, 64.0f).optionalFieldOf("max_creative_reach", (Object)Float.valueOf(5.0f)).forGetter(AttackRange::maxCreativeRange), (App)ExtraCodecs.floatRange(0.0f, 1.0f).optionalFieldOf("hitbox_margin", (Object)Float.valueOf(0.3f)).forGetter(AttackRange::hitboxMargin), (App)Codec.floatRange((float)0.0f, (float)2.0f).optionalFieldOf("mob_factor", (Object)Float.valueOf(1.0f)).forGetter(AttackRange::mobFactor)).apply((Applicative)var0, AttackRange::new));
    public static final StreamCodec<ByteBuf, AttackRange> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.FLOAT, AttackRange::minRange, ByteBufCodecs.FLOAT, AttackRange::maxRange, ByteBufCodecs.FLOAT, AttackRange::minCreativeRange, ByteBufCodecs.FLOAT, AttackRange::maxCreativeRange, ByteBufCodecs.FLOAT, AttackRange::hitboxMargin, ByteBufCodecs.FLOAT, AttackRange::mobFactor, AttackRange::new);

    public static AttackRange defaultFor(LivingEntity var0) {
        return new AttackRange(0.0f, (float)var0.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE), 0.0f, (float)var0.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE), 0.0f, 1.0f);
    }

    public HitResult getClosesetHit(Entity var0, float var1, Predicate<Entity> var2) {
        Object var102;
        Either<BlockHitResult, Collection<EntityHitResult>> var3 = ProjectileUtil.getHitEntitiesAlong(var0, this, var2, ClipContext.Block.OUTLINE);
        if (var3.left().isPresent()) {
            return (HitResult)var3.left().get();
        }
        Collection var4 = (Collection)var3.right().get();
        Object var5 = null;
        Vec3 var6 = var0.getEyePosition(var1);
        double var7 = Double.MAX_VALUE;
        for (Object var102 : var4) {
            double var11 = var6.distanceToSqr(((HitResult)var102).getLocation());
            if (!(var11 < var7)) continue;
            var7 = var11;
            var5 = var102;
        }
        if (var5 != null) {
            return var5;
        }
        Vec3 var9 = var0.getHeadLookAngle();
        var102 = var0.getEyePosition(var1).add(var9);
        return BlockHitResult.miss((Vec3)var102, Direction.getApproximateNearest(var9), BlockPos.containing((Position)var102));
    }

    public float effectiveMinRange(Entity var0) {
        if (var0 instanceof Player) {
            Player var1 = (Player)var0;
            if (var1.isSpectator()) {
                return 0.0f;
            }
            return var1.isCreative() ? this.minCreativeRange : this.minRange;
        }
        return this.minRange * this.mobFactor;
    }

    public float effectiveMaxRange(Entity var0) {
        if (var0 instanceof Player) {
            Player var1 = (Player)var0;
            return var1.isCreative() ? this.maxCreativeRange : this.maxRange;
        }
        return this.maxRange * this.mobFactor;
    }

    public boolean isInRange(LivingEntity var0, Vec3 var1) {
        return this.isInRange(var0, var1::distanceToSqr, 0.0);
    }

    public boolean isInRange(LivingEntity var0, AABB var1, double var2) {
        return this.isInRange(var0, var1::distanceToSqr, var2);
    }

    private boolean isInRange(LivingEntity var0, ToDoubleFunction<Vec3> var1, double var2) {
        double var4 = Math.sqrt(var1.applyAsDouble(var0.getEyePosition()));
        double var6 = (double)(this.effectiveMinRange(var0) - this.hitboxMargin) - var2;
        double var8 = (double)(this.effectiveMaxRange(var0) + this.hitboxMargin) + var2;
        return var4 >= var6 && var4 <= var8;
    }
}

