/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class FireworkStarFadeRecipe
extends CustomRecipe {
    private static final Ingredient STAR_INGREDIENT = Ingredient.of((ItemLike)Items.FIREWORK_STAR);

    public FireworkStarFadeRecipe(CraftingBookCategory var0) {
        super(var0);
    }

    @Override
    public boolean matches(CraftingInput var0, Level var1) {
        if (var0.ingredientCount() < 2) {
            return false;
        }
        boolean var2 = false;
        boolean var3 = false;
        for (int var4 = 0; var4 < var0.size(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            if (var5.isEmpty()) continue;
            if (var5.getItem() instanceof DyeItem) {
                var2 = true;
                continue;
            }
            if (STAR_INGREDIENT.test(var5)) {
                if (var3) {
                    return false;
                }
                var3 = true;
                continue;
            }
            return false;
        }
        return var3 && var2;
    }

    @Override
    public ItemStack assemble(CraftingInput var0, HolderLookup.Provider var1) {
        IntArrayList var2 = new IntArrayList();
        ItemStack var3 = null;
        for (int var4 = 0; var4 < var0.size(); ++var4) {
            ItemStack var5 = var0.getItem(var4);
            Item var6 = var5.getItem();
            if (var6 instanceof DyeItem) {
                DyeItem var7 = (DyeItem)var6;
                var2.add(var7.getDyeColor().getFireworkColor());
                continue;
            }
            if (!STAR_INGREDIENT.test(var5)) continue;
            var3 = var5.copyWithCount(1);
        }
        if (var3 == null || var2.isEmpty()) {
            return ItemStack.EMPTY;
        }
        var3.update(DataComponents.FIREWORK_EXPLOSION, FireworkExplosion.DEFAULT, var2, FireworkExplosion::withFadeColors);
        return var3;
    }

    @Override
    public RecipeSerializer<FireworkStarFadeRecipe> getSerializer() {
        return RecipeSerializer.FIREWORK_STAR_FADE;
    }
}

