/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;

public final class Ingredient
implements StackedContents.IngredientInfo<Holder<Item>>,
Predicate<ItemStack> {
    public static final StreamCodec<RegistryFriendlyByteBuf, Ingredient> CONTENTS_STREAM_CODEC = ByteBufCodecs.holderSet(Registries.ITEM).map(Ingredient::new, recipeitemstack -> recipeitemstack.values);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<Ingredient>> OPTIONAL_CONTENTS_STREAM_CODEC = ByteBufCodecs.holderSet(Registries.ITEM).map(holderset -> holderset.size() == 0 ? Optional.empty() : Optional.of(new Ingredient((HolderSet<Item>)holderset)), optional -> optional.map(recipeitemstack -> recipeitemstack.values).orElse(HolderSet.direct(new Holder[0])));
    public static final Codec<HolderSet<Item>> NON_AIR_HOLDER_SET_CODEC = HolderSetCodec.create(Registries.ITEM, Item.CODEC, false);
    public static final Codec<Ingredient> CODEC = ExtraCodecs.nonEmptyHolderSet(NON_AIR_HOLDER_SET_CODEC).xmap(Ingredient::new, recipeitemstack -> recipeitemstack.values);
    private final HolderSet<Item> values;
    @Nullable
    private List<ItemStack> itemStacks;

    public boolean isExact() {
        return this.itemStacks != null;
    }

    public List<ItemStack> itemStacks() {
        return this.itemStacks;
    }

    public static Ingredient ofStacks(List<ItemStack> stacks) {
        Ingredient recipe = Ingredient.of(stacks.stream().map(ItemStack::getItem));
        recipe.itemStacks = stacks;
        return recipe;
    }

    private Ingredient(HolderSet<Item> holderset) {
        holderset.unwrap().ifRight(list -> {
            if (list.isEmpty()) {
                throw new UnsupportedOperationException("Ingredients can't be empty");
            }
            if (list.contains(Items.AIR.builtInRegistryHolder())) {
                throw new UnsupportedOperationException("Ingredient can't contain air");
            }
        });
        this.values = holderset;
    }

    public static boolean testOptionalIngredient(Optional<Ingredient> optional, ItemStack itemstack) {
        Optional<Boolean> optional1 = optional.map(recipeitemstack -> recipeitemstack.test(itemstack));
        Objects.requireNonNull(itemstack);
        return (Boolean)optional1.orElseGet(itemstack::isEmpty);
    }

    @Deprecated
    public Stream<Holder<Item>> items() {
        return this.values.stream();
    }

    public boolean isEmpty() {
        return this.values.size() == 0;
    }

    @Override
    public boolean test(ItemStack itemstack) {
        if (this.isExact()) {
            for (ItemStack itemstack1 : this.itemStacks()) {
                if (itemstack1.getItem() != itemstack.getItem() || !ItemStack.isSameItemSameComponents(itemstack, itemstack1)) continue;
                return true;
            }
            return false;
        }
        return itemstack.is(this.values);
    }

    @Override
    public boolean acceptsItem(Holder<Item> holder) {
        return this.values.contains(holder);
    }

    public boolean equals(Object object) {
        if (object instanceof Ingredient) {
            Ingredient recipeitemstack = (Ingredient)object;
            return Objects.equals(this.values, recipeitemstack.values) && Objects.equals(this.itemStacks, recipeitemstack.itemStacks);
        }
        return false;
    }

    public static Ingredient of(ItemLike imaterial) {
        return new Ingredient(HolderSet.direct(imaterial.asItem().builtInRegistryHolder()));
    }

    public static Ingredient of(ItemLike ... aimaterial) {
        return Ingredient.of(Arrays.stream(aimaterial));
    }

    public static Ingredient of(Stream<? extends ItemLike> stream) {
        return new Ingredient(HolderSet.direct(stream.map(imaterial -> imaterial.asItem().builtInRegistryHolder()).toList()));
    }

    public static Ingredient of(HolderSet<Item> holderset) {
        return new Ingredient(holderset);
    }

    public SlotDisplay display() {
        return (SlotDisplay)this.values.unwrap().map(SlotDisplay.TagSlotDisplay::new, list -> new SlotDisplay.Composite(list.stream().map(Ingredient::displayForSingleItem).toList()));
    }

    public static SlotDisplay optionalIngredientToDisplay(Optional<Ingredient> optional) {
        return optional.map(Ingredient::display).orElse(SlotDisplay.Empty.INSTANCE);
    }

    private static SlotDisplay displayForSingleItem(Holder<Item> holder) {
        SlotDisplay.ItemSlotDisplay slotdisplay = new SlotDisplay.ItemSlotDisplay(holder);
        ItemStack itemstack = holder.value().getCraftingRemainder();
        if (!itemstack.isEmpty()) {
            SlotDisplay.ItemStackSlotDisplay slotdisplay1 = new SlotDisplay.ItemStackSlotDisplay(itemstack);
            return new SlotDisplay.WithRemainder(slotdisplay, slotdisplay1);
        }
        return slotdisplay;
    }
}

