/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public class RecipeMap {
    public static final RecipeMap EMPTY = new RecipeMap((Multimap<RecipeType<?>, RecipeHolder<?>>)ImmutableMultimap.of(), Maps.newLinkedHashMap());
    public final Multimap<RecipeType<?>, RecipeHolder<?>> byType;
    private final LinkedHashMap<ResourceKey<Recipe<?>>, RecipeHolder<?>> c;

    private RecipeMap(Multimap<RecipeType<?>, RecipeHolder<?>> multimap, LinkedHashMap<ResourceKey<Recipe<?>>, RecipeHolder<?>> map) {
        this.byType = multimap;
        this.c = map;
    }

    public static RecipeMap create(Iterable<RecipeHolder<?>> iterable) {
        ImmutableMultimap.Builder immutablemultimap_builder = ImmutableMultimap.builder();
        ImmutableMap.Builder immutablemap_builder = ImmutableMap.builder();
        for (RecipeHolder<?> recipeholder : iterable) {
            immutablemultimap_builder.put(recipeholder.value().getType(), recipeholder);
            immutablemap_builder.put(recipeholder.id(), recipeholder);
        }
        return new RecipeMap((Multimap<RecipeType<?>, RecipeHolder<?>>)LinkedHashMultimap.create((Multimap)immutablemultimap_builder.build()), Maps.newLinkedHashMap((Map)immutablemap_builder.build()));
    }

    public void addRecipe(RecipeHolder<?> irecipe) {
        Collection map = this.byType.get(irecipe.value().getType());
        if (this.c.containsKey(irecipe.id())) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + String.valueOf(irecipe.id()));
        }
        map.add(irecipe);
        this.c.putFirst(irecipe.id(), irecipe);
    }

    public boolean removeRecipe(ResourceKey<Recipe<?>> mcKey) {
        boolean removed = false;
        Iterator iter = this.byType.values().iterator();
        while (iter.hasNext()) {
            RecipeHolder recipe = (RecipeHolder)iter.next();
            if (!recipe.id().equals(mcKey)) continue;
            iter.remove();
            removed = true;
        }
        return removed |= this.c.remove(mcKey) != null;
    }

    public <I extends RecipeInput, T extends Recipe<I>> Collection<RecipeHolder<T>> byType(RecipeType<T> recipes) {
        return this.byType.get(recipes);
    }

    public Collection<RecipeHolder<?>> values() {
        return this.c.values();
    }

    public @Nullable RecipeHolder<?> byKey(ResourceKey<Recipe<?>> resourcekey) {
        return this.c.get(resourcekey);
    }

    public <I extends RecipeInput, T extends Recipe<I>> Stream<RecipeHolder<T>> getRecipesFor(RecipeType<T> recipes, I i0, Level world) {
        return i0.isEmpty() ? Stream.empty() : this.byType(recipes).stream().filter(recipeholder -> recipeholder.value().matches((RecipeInput)i0, world));
    }
}

