/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.phys.Vec3;

public interface AllOf {
    public static <T, A extends T> MapCodec<A> codec(Codec<T> var0, Function<List<T>, A> var1, Function<A, List<T>> var2) {
        return RecordCodecBuilder.mapCodec(var3 -> var3.group((App)var0.listOf().fieldOf("effects").forGetter(var2)).apply((Applicative)var3, var1));
    }

    public static EntityEffects entityEffects(EnchantmentEntityEffect ... var0) {
        return new EntityEffects(List.of(var0));
    }

    public static LocationBasedEffects locationBasedEffects(EnchantmentLocationBasedEffect ... var0) {
        return new LocationBasedEffects(List.of(var0));
    }

    public static ValueEffects valueEffects(EnchantmentValueEffect ... var0) {
        return new ValueEffects(List.of(var0));
    }

    public record EntityEffects(List<EnchantmentEntityEffect> effects) implements EnchantmentEntityEffect
    {
        public static final MapCodec<EntityEffects> CODEC = AllOf.codec(EnchantmentEntityEffect.CODEC, EntityEffects::new, EntityEffects::effects);

        @Override
        public void apply(ServerLevel var0, int var1, EnchantedItemInUse var2, Entity var3, Vec3 var4) {
            for (EnchantmentEntityEffect var6 : this.effects) {
                var6.apply(var0, var1, var2, var3, var4);
            }
        }

        public MapCodec<EntityEffects> codec() {
            return CODEC;
        }
    }

    public record LocationBasedEffects(List<EnchantmentLocationBasedEffect> effects) implements EnchantmentLocationBasedEffect
    {
        public static final MapCodec<LocationBasedEffects> CODEC = AllOf.codec(EnchantmentLocationBasedEffect.CODEC, LocationBasedEffects::new, LocationBasedEffects::effects);

        @Override
        public void onChangedBlock(ServerLevel var0, int var1, EnchantedItemInUse var2, Entity var3, Vec3 var4, boolean var5) {
            for (EnchantmentLocationBasedEffect var7 : this.effects) {
                var7.onChangedBlock(var0, var1, var2, var3, var4, var5);
            }
        }

        @Override
        public void onDeactivated(EnchantedItemInUse var0, Entity var1, Vec3 var2, int var3) {
            for (EnchantmentLocationBasedEffect var5 : this.effects) {
                var5.onDeactivated(var0, var1, var2, var3);
            }
        }

        public MapCodec<LocationBasedEffects> codec() {
            return CODEC;
        }
    }

    public record ValueEffects(List<EnchantmentValueEffect> effects) implements EnchantmentValueEffect
    {
        public static final MapCodec<ValueEffects> CODEC = AllOf.codec(EnchantmentValueEffect.CODEC, ValueEffects::new, ValueEffects::effects);

        @Override
        public float process(int var0, RandomSource var1, float var2) {
            for (EnchantmentValueEffect var4 : this.effects) {
                var2 = var4.process(var0, var1, var2);
            }
            return var2;
        }

        public MapCodec<ValueEffects> codec() {
            return CODEC;
        }
    }
}

