/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public record ApplyMobEffect(HolderSet<MobEffect> toApply, LevelBasedValue minDuration, LevelBasedValue maxDuration, LevelBasedValue minAmplifier, LevelBasedValue maxAmplifier) implements EnchantmentEntityEffect
{
    public static final MapCodec<ApplyMobEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList(Registries.MOB_EFFECT).fieldOf("to_apply").forGetter(ApplyMobEffect::toApply), (App)LevelBasedValue.CODEC.fieldOf("min_duration").forGetter(ApplyMobEffect::minDuration), (App)LevelBasedValue.CODEC.fieldOf("max_duration").forGetter(ApplyMobEffect::maxDuration), (App)LevelBasedValue.CODEC.fieldOf("min_amplifier").forGetter(ApplyMobEffect::minAmplifier), (App)LevelBasedValue.CODEC.fieldOf("max_amplifier").forGetter(ApplyMobEffect::maxAmplifier)).apply((Applicative)instance, ApplyMobEffect::new));

    @Override
    public void apply(ServerLevel worldserver, int i, EnchantedItemInUse enchantediteminuse, Entity entity, Vec3 vec3d) {
        LivingEntity entityliving;
        RandomSource randomsource;
        Optional<Holder<MobEffect>> optional;
        if (entity instanceof LivingEntity && (optional = this.toApply.getRandomElement(randomsource = (entityliving = (LivingEntity)entity).getRandom())).isPresent()) {
            int j = Math.round(Mth.randomBetween(randomsource, this.minDuration.calculate(i), this.maxDuration.calculate(i)) * 20.0f);
            int k = Math.max(0, Math.round(Mth.randomBetween(randomsource, this.minAmplifier.calculate(i), this.maxAmplifier.calculate(i))));
            entityliving.addEffect(new MobEffectInstance(optional.get(), j, k), EntityPotionEffectEvent.Cause.ATTACK);
        }
    }

    public MapCodec<ApplyMobEffect> codec() {
        return CODEC;
    }
}

