/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;

public record Equippable(EquipmentSlot slot, Holder<SoundEvent> equipSound, Optional<ResourceKey<EquipmentAsset>> assetId, Optional<Identifier> cameraOverlay, Optional<HolderSet<EntityType<?>>> allowedEntities, boolean dispensable, boolean swappable, boolean damageOnHurt, boolean equipOnInteract, boolean canBeSheared, Holder<SoundEvent> shearingSound) {
    public static final Codec<Equippable> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)EquipmentSlot.CODEC.fieldOf("slot").forGetter(Equippable::slot), (App)SoundEvent.CODEC.optionalFieldOf("equip_sound", SoundEvents.ARMOR_EQUIP_GENERIC).forGetter(Equippable::equipSound), (App)ResourceKey.codec(EquipmentAssets.ROOT_ID).optionalFieldOf("asset_id").forGetter(Equippable::assetId), (App)Identifier.CODEC.optionalFieldOf("camera_overlay").forGetter(Equippable::cameraOverlay), (App)RegistryCodecs.homogeneousList(Registries.ENTITY_TYPE).optionalFieldOf("allowed_entities").forGetter(Equippable::allowedEntities), (App)Codec.BOOL.optionalFieldOf("dispensable", (Object)true).forGetter(Equippable::dispensable), (App)Codec.BOOL.optionalFieldOf("swappable", (Object)true).forGetter(Equippable::swappable), (App)Codec.BOOL.optionalFieldOf("damage_on_hurt", (Object)true).forGetter(Equippable::damageOnHurt), (App)Codec.BOOL.optionalFieldOf("equip_on_interact", (Object)false).forGetter(Equippable::equipOnInteract), (App)Codec.BOOL.optionalFieldOf("can_be_sheared", (Object)false).forGetter(Equippable::canBeSheared), (App)SoundEvent.CODEC.optionalFieldOf("shearing_sound", BuiltInRegistries.SOUND_EVENT.wrapAsHolder(SoundEvents.SHEARS_SNIP)).forGetter(Equippable::shearingSound)).apply((Applicative)var0, Equippable::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Equippable> STREAM_CODEC = StreamCodec.composite(EquipmentSlot.STREAM_CODEC, Equippable::slot, SoundEvent.STREAM_CODEC, Equippable::equipSound, ResourceKey.streamCodec(EquipmentAssets.ROOT_ID).apply(ByteBufCodecs::optional), Equippable::assetId, Identifier.STREAM_CODEC.apply(ByteBufCodecs::optional), Equippable::cameraOverlay, ByteBufCodecs.holderSet(Registries.ENTITY_TYPE).apply(ByteBufCodecs::optional), Equippable::allowedEntities, ByteBufCodecs.BOOL, Equippable::dispensable, ByteBufCodecs.BOOL, Equippable::swappable, ByteBufCodecs.BOOL, Equippable::damageOnHurt, ByteBufCodecs.BOOL, Equippable::equipOnInteract, ByteBufCodecs.BOOL, Equippable::canBeSheared, SoundEvent.STREAM_CODEC, Equippable::shearingSound, Equippable::new);

    public static Equippable llamaSwag(DyeColor var0) {
        return Equippable.builder(EquipmentSlot.BODY).setEquipSound(SoundEvents.LLAMA_SWAG).setAsset(EquipmentAssets.CARPETS.get(var0)).setAllowedEntities(EntityType.LLAMA, EntityType.TRADER_LLAMA).setCanBeSheared(true).setShearingSound(SoundEvents.LLAMA_CARPET_UNEQUIP).build();
    }

    public static Equippable saddle() {
        HolderGetter<EntityType<?>> var0 = BuiltInRegistries.acquireBootstrapRegistrationLookup(BuiltInRegistries.ENTITY_TYPE);
        return Equippable.builder(EquipmentSlot.SADDLE).setEquipSound(SoundEvents.HORSE_SADDLE).setAsset(EquipmentAssets.SADDLE).setAllowedEntities(var0.getOrThrow(EntityTypeTags.CAN_EQUIP_SADDLE)).setEquipOnInteract(true).setCanBeSheared(true).setShearingSound(SoundEvents.SADDLE_UNEQUIP).build();
    }

    public static Equippable harness(DyeColor var0) {
        HolderGetter<EntityType<?>> var1 = BuiltInRegistries.acquireBootstrapRegistrationLookup(BuiltInRegistries.ENTITY_TYPE);
        return Equippable.builder(EquipmentSlot.BODY).setEquipSound(SoundEvents.HARNESS_EQUIP).setAsset(EquipmentAssets.HARNESSES.get(var0)).setAllowedEntities(var1.getOrThrow(EntityTypeTags.CAN_EQUIP_HARNESS)).setEquipOnInteract(true).setCanBeSheared(true).setShearingSound(BuiltInRegistries.SOUND_EVENT.wrapAsHolder(SoundEvents.HARNESS_UNEQUIP)).build();
    }

    public static Builder builder(EquipmentSlot var0) {
        return new Builder(var0);
    }

    public InteractionResult swapWithEquipmentSlot(ItemStack var0, Player var1) {
        if (!var1.canUseSlot(this.slot) || !this.canBeEquippedBy(var1.getType())) {
            return InteractionResult.PASS;
        }
        ItemStack var2 = var1.getItemBySlot(this.slot);
        if (EnchantmentHelper.has(var2, EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE) && !var1.isCreative() || ItemStack.isSameItemSameComponents(var0, var2)) {
            return InteractionResult.FAIL;
        }
        if (!var1.level().isClientSide()) {
            var1.awardStat(Stats.ITEM_USED.get(var0.getItem()));
        }
        if (var0.getCount() <= 1) {
            ItemStack var3 = var2.isEmpty() ? var0 : var2.copyAndClear();
            ItemStack var4 = var1.isCreative() ? var0.copy() : var0.copyAndClear();
            var1.setItemSlot(this.slot, var4);
            return InteractionResult.SUCCESS.heldItemTransformedTo(var3);
        }
        ItemStack var3 = var2.copyAndClear();
        ItemStack var4 = var0.consumeAndReturn(1, var1);
        var1.setItemSlot(this.slot, var4);
        if (!var1.getInventory().add(var3)) {
            var1.drop(var3, false);
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(var0);
    }

    public InteractionResult equipOnTarget(Player var0, LivingEntity var1, ItemStack var2) {
        if (!var1.isEquippableInSlot(var2, this.slot) || var1.hasItemInSlot(this.slot) || !var1.isAlive()) {
            return InteractionResult.PASS;
        }
        if (!var0.level().isClientSide()) {
            var1.setItemSlot(this.slot, var2.split(1));
            if (var1 instanceof Mob) {
                Mob var3 = (Mob)var1;
                var3.setGuaranteedDrop(this.slot);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canBeEquippedBy(EntityType<?> var0) {
        return this.allowedEntities.isEmpty() || this.allowedEntities.get().contains(var0.builtInRegistryHolder());
    }

    public static class Builder {
        private final EquipmentSlot slot;
        private Holder<SoundEvent> equipSound = SoundEvents.ARMOR_EQUIP_GENERIC;
        private Optional<ResourceKey<EquipmentAsset>> assetId = Optional.empty();
        private Optional<Identifier> cameraOverlay = Optional.empty();
        private Optional<HolderSet<EntityType<?>>> allowedEntities = Optional.empty();
        private boolean dispensable = true;
        private boolean swappable = true;
        private boolean damageOnHurt = true;
        private boolean equipOnInteract;
        private boolean canBeSheared;
        private Holder<SoundEvent> shearingSound = BuiltInRegistries.SOUND_EVENT.wrapAsHolder(SoundEvents.SHEARS_SNIP);

        Builder(EquipmentSlot var0) {
            this.slot = var0;
        }

        public Builder setEquipSound(Holder<SoundEvent> var0) {
            this.equipSound = var0;
            return this;
        }

        public Builder setAsset(ResourceKey<EquipmentAsset> var0) {
            this.assetId = Optional.of(var0);
            return this;
        }

        public Builder setCameraOverlay(Identifier var0) {
            this.cameraOverlay = Optional.of(var0);
            return this;
        }

        public Builder setAllowedEntities(EntityType<?> ... var0) {
            return this.setAllowedEntities(HolderSet.direct(EntityType::builtInRegistryHolder, var0));
        }

        public Builder setAllowedEntities(HolderSet<EntityType<?>> var0) {
            this.allowedEntities = Optional.of(var0);
            return this;
        }

        public Builder setDispensable(boolean var0) {
            this.dispensable = var0;
            return this;
        }

        public Builder setSwappable(boolean var0) {
            this.swappable = var0;
            return this;
        }

        public Builder setDamageOnHurt(boolean var0) {
            this.damageOnHurt = var0;
            return this;
        }

        public Builder setEquipOnInteract(boolean var0) {
            this.equipOnInteract = var0;
            return this;
        }

        public Builder setCanBeSheared(boolean var0) {
            this.canBeSheared = var0;
            return this;
        }

        public Builder setShearingSound(Holder<SoundEvent> var0) {
            this.shearingSound = var0;
            return this;
        }

        public Equippable build() {
            return new Equippable(this.slot, this.equipSound, this.assetId, this.cameraOverlay, this.allowedEntities, this.dispensable, this.swappable, this.damageOnHurt, this.equipOnInteract, this.canBeSheared, this.shearingSound);
        }
    }
}

