/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.slot;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.slot.ContentsSlotSource;
import net.minecraft.world.item.slot.EmptySlotSource;
import net.minecraft.world.item.slot.FilteredSlotSource;
import net.minecraft.world.item.slot.GroupSlotSource;
import net.minecraft.world.item.slot.LimitSlotSource;
import net.minecraft.world.item.slot.RangeSlotSource;
import net.minecraft.world.item.slot.SlotCollection;
import net.minecraft.world.item.slot.SlotSource;
import net.minecraft.world.level.storage.loot.LootContext;

public interface SlotSources {
    public static final Codec<SlotSource> TYPED_CODEC = BuiltInRegistries.SLOT_SOURCE_TYPE.byNameCodec().dispatch(SlotSource::codec, var0 -> var0);
    public static final Codec<SlotSource> CODEC = Codec.lazyInitialized(() -> Codec.withAlternative(TYPED_CODEC, GroupSlotSource.INLINE_CODEC));

    public static MapCodec<? extends SlotSource> bootstrap(Registry<MapCodec<? extends SlotSource>> var0) {
        Registry.register(var0, "group", GroupSlotSource.MAP_CODEC);
        Registry.register(var0, "filtered", FilteredSlotSource.MAP_CODEC);
        Registry.register(var0, "limit_slots", LimitSlotSource.MAP_CODEC);
        Registry.register(var0, "slot_range", RangeSlotSource.MAP_CODEC);
        Registry.register(var0, "contents", ContentsSlotSource.MAP_CODEC);
        return Registry.register(var0, "empty", EmptySlotSource.MAP_CODEC);
    }

    public static Function<LootContext, SlotCollection> group(Collection<? extends SlotSource> var02) {
        List<? extends SlotSource> var12 = List.copyOf(var02);
        return switch (var12.size()) {
            case 0 -> var0 -> SlotCollection.EMPTY;
            case 1 -> var12.getFirst()::provide;
            case 2 -> {
                SlotSource var2 = var12.get(0);
                SlotSource var3 = var12.get(1);
                yield var2 -> SlotCollection.concat(var2.provide((LootContext)var2), var3.provide((LootContext)var2));
            }
            default -> var1 -> {
                ArrayList<SlotCollection> var2 = new ArrayList<SlotCollection>();
                for (SlotSource var4 : var12) {
                    var2.add(var4.provide((LootContext)var1));
                }
                return SlotCollection.concat(var2);
            };
        };
    }
}

