/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.trading;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import org.jspecify.annotations.Nullable;

public class MerchantOffers
extends ArrayList<MerchantOffer> {
    public static final Codec<MerchantOffers> CODEC = MerchantOffer.CODEC.listOf().optionalFieldOf("Recipes", List.of()).xmap(MerchantOffers::new, Function.identity()).codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, MerchantOffers> STREAM_CODEC = MerchantOffer.STREAM_CODEC.apply(ByteBufCodecs.collection(MerchantOffers::new));

    public MerchantOffers() {
    }

    private MerchantOffers(int var0) {
        super(var0);
    }

    private MerchantOffers(Collection<MerchantOffer> var0) {
        super(var0);
    }

    public @Nullable MerchantOffer getRecipeFor(ItemStack var0, ItemStack var1, int var2) {
        if (var2 > 0 && var2 < this.size()) {
            MerchantOffer var3 = (MerchantOffer)this.get(var2);
            if (var3.satisfiedBy(var0, var1)) {
                return var3;
            }
            return null;
        }
        for (int var3 = 0; var3 < this.size(); ++var3) {
            MerchantOffer var4 = (MerchantOffer)this.get(var3);
            if (!var4.satisfiedBy(var0, var1)) continue;
            return var4;
        }
        return null;
    }

    public MerchantOffers copy() {
        MerchantOffers var0 = new MerchantOffers(this.size());
        for (MerchantOffer var2 : this) {
            var0.add(var2.copy());
        }
        return var0;
    }
}

