/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.Nullable;

public abstract class BaseCommandBlock {
    private static final Component DEFAULT_NAME = Component.literal("@");
    private static final int NO_LAST_EXECUTION = -1;
    private long lastExecution = -1L;
    private boolean updateLastExecution = true;
    private int successCount;
    private boolean trackOutput = true;
    @Nullable Component lastOutput;
    private String command = "";
    private @Nullable Component customName;

    public abstract CommandSender getBukkitSender(CommandSourceStack var1);

    public int getSuccessCount() {
        return this.successCount;
    }

    public void setSuccessCount(int i) {
        this.successCount = i;
    }

    public Component getLastOutput() {
        return this.lastOutput == null ? CommonComponents.EMPTY : this.lastOutput;
    }

    public void save(ValueOutput valueoutput) {
        valueoutput.putString("Command", this.command);
        valueoutput.putInt("SuccessCount", this.successCount);
        valueoutput.storeNullable("CustomName", ComponentSerialization.CODEC, this.customName);
        valueoutput.putBoolean("TrackOutput", this.trackOutput);
        if (this.trackOutput) {
            valueoutput.storeNullable("LastOutput", ComponentSerialization.CODEC, this.lastOutput);
        }
        valueoutput.putBoolean("UpdateLastExecution", this.updateLastExecution);
        if (this.updateLastExecution && this.lastExecution != -1L) {
            valueoutput.putLong("LastExecution", this.lastExecution);
        }
    }

    public void load(ValueInput valueinput) {
        this.command = valueinput.getStringOr("Command", "");
        this.successCount = valueinput.getIntOr("SuccessCount", 0);
        this.setCustomName(BlockEntity.parseCustomNameSafe(valueinput, "CustomName"));
        this.trackOutput = valueinput.getBooleanOr("TrackOutput", true);
        this.lastOutput = this.trackOutput ? BlockEntity.parseCustomNameSafe(valueinput, "LastOutput") : null;
        this.updateLastExecution = valueinput.getBooleanOr("UpdateLastExecution", true);
        this.lastExecution = this.updateLastExecution ? valueinput.getLongOr("LastExecution", -1L) : -1L;
    }

    public void setCommand(String s) {
        this.command = s;
        this.successCount = 0;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean performCommand(ServerLevel worldserver) {
        if (worldserver.getGameTime() == this.lastExecution) {
            return false;
        }
        if ("Searge".equalsIgnoreCase(this.command)) {
            this.lastOutput = Component.literal("#itzlipofutzli");
            this.successCount = 1;
            return true;
        }
        this.successCount = 0;
        if (worldserver.isCommandBlockEnabled() && !StringUtil.isNullOrEmpty(this.command)) {
            try {
                this.lastOutput = null;
                try (CloseableCommandBlockSource commandblocklistenerabstract_closeablecommandblocksource = this.createSource(worldserver);){
                    CommandSource icommandlistener = Objects.requireNonNullElse(commandblocklistenerabstract_closeablecommandblocksource, CommandSource.NULL);
                    CommandSourceStack commandlistenerwrapper = this.createCommandSourceStack(worldserver, icommandlistener).withCallback((flag, i) -> {
                        if (flag) {
                            ++this.successCount;
                        }
                    });
                    worldserver.getServer().getCommands().dispatchServerCommand(commandlistenerwrapper, this.command);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.forThrowable(throwable, "Executing command block");
                CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Command to be executed");
                crashreportsystemdetails.setDetail("Command", this::getCommand);
                crashreportsystemdetails.setDetail("Name", () -> this.getName().getString());
                throw new ReportedException(crashreport);
            }
        }
        this.lastExecution = this.updateLastExecution ? worldserver.getGameTime() : -1L;
        return true;
    }

    public @Nullable CloseableCommandBlockSource createSource(ServerLevel worldserver) {
        CloseableCommandBlockSource source = new CloseableCommandBlockSource(worldserver);
        source.closed = !this.trackOutput;
        return source;
    }

    public Component getName() {
        return this.customName != null ? this.customName : DEFAULT_NAME;
    }

    public @Nullable Component getCustomName() {
        return this.customName;
    }

    public void setCustomName(@Nullable Component ichatbasecomponent) {
        this.customName = ichatbasecomponent;
    }

    public abstract void onUpdated(ServerLevel var1);

    public void setLastOutput(@Nullable Component ichatbasecomponent) {
        this.lastOutput = ichatbasecomponent;
    }

    public void setTrackOutput(boolean flag) {
        this.trackOutput = flag;
    }

    public boolean isTrackOutput() {
        return this.trackOutput;
    }

    public abstract CommandSourceStack createCommandSourceStack(ServerLevel var1, CommandSource var2);

    public abstract boolean isValid();

    protected class CloseableCommandBlockSource
    implements CommandSource,
    AutoCloseable {
        private final ServerLevel level;
        private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ROOT);
        private boolean closed;

        protected CloseableCommandBlockSource(ServerLevel worldserver) {
            this.level = worldserver;
        }

        @Override
        public CommandSender getBukkitSender(CommandSourceStack wrapper) {
            return BaseCommandBlock.this.getBukkitSender(wrapper);
        }

        @Override
        public boolean acceptsSuccess() {
            return !this.closed && this.level.getGameRules().get(GameRules.SEND_COMMAND_FEEDBACK) != false;
        }

        @Override
        public boolean acceptsFailure() {
            return !this.closed;
        }

        @Override
        public boolean shouldInformAdmins() {
            return !this.closed && this.level.getGameRules().get(GameRules.COMMAND_BLOCK_OUTPUT) != false;
        }

        @Override
        public void sendSystemMessage(Component ichatbasecomponent) {
            if (!this.closed) {
                DateTimeFormatter datetimeformatter = TIME_FORMAT;
                BaseCommandBlock.this.lastOutput = Component.literal("[" + datetimeformatter.format(ZonedDateTime.now()) + "] ").append(ichatbasecomponent);
                BaseCommandBlock.this.onUpdated(this.level);
            }
        }

        @Override
        public void close() throws Exception {
            this.closed = true;
        }
    }
}

