/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public interface BlockGetter
extends LevelHeightAccessor {
    public @Nullable BlockEntity getBlockEntity(BlockPos var1);

    default public <T extends BlockEntity> Optional<T> getBlockEntity(BlockPos blockposition, BlockEntityType<T> tileentitytypes) {
        BlockEntity tileentity = this.getBlockEntity(blockposition);
        return tileentity != null && tileentity.getType() == tileentitytypes ? Optional.of(tileentity) : Optional.empty();
    }

    public BlockState getBlockState(BlockPos var1);

    public FluidState getFluidState(BlockPos var1);

    default public int getLightEmission(BlockPos blockposition) {
        return this.getBlockState(blockposition).getLightEmission();
    }

    default public Stream<BlockState> getBlockStates(AABB axisalignedbb) {
        return BlockPos.betweenClosedStream(axisalignedbb).map(this::getBlockState);
    }

    default public BlockHitResult isBlockInLine(ClipBlockStateContext clipblockstatecontext) {
        return BlockGetter.traverseBlocks(clipblockstatecontext.getFrom(), clipblockstatecontext.getTo(), clipblockstatecontext, (clipblockstatecontext1, blockposition) -> {
            BlockState iblockdata = this.getBlockState((BlockPos)blockposition);
            Vec3 vec3d = clipblockstatecontext1.getFrom().subtract(clipblockstatecontext1.getTo());
            return clipblockstatecontext1.isTargetBlock().test(iblockdata) ? new BlockHitResult(clipblockstatecontext1.getTo(), Direction.getApproximateNearest(vec3d.x, vec3d.y, vec3d.z), BlockPos.containing(clipblockstatecontext1.getTo()), false) : null;
        }, clipblockstatecontext1 -> {
            Vec3 vec3d = clipblockstatecontext1.getFrom().subtract(clipblockstatecontext1.getTo());
            return BlockHitResult.miss(clipblockstatecontext1.getTo(), Direction.getApproximateNearest(vec3d.x, vec3d.y, vec3d.z), BlockPos.containing(clipblockstatecontext1.getTo()));
        });
    }

    default public BlockHitResult clip(ClipContext raytrace1, BlockPos blockposition) {
        BlockState iblockdata = this.getBlockState(blockposition);
        FluidState fluid = this.getFluidState(blockposition);
        Vec3 vec3d = raytrace1.getFrom();
        Vec3 vec3d1 = raytrace1.getTo();
        VoxelShape voxelshape = raytrace1.getBlockShape(iblockdata, this, blockposition);
        BlockHitResult movingobjectpositionblock = this.clipWithInteractionOverride(vec3d, vec3d1, blockposition, voxelshape, iblockdata);
        VoxelShape voxelshape1 = raytrace1.getFluidShape(fluid, this, blockposition);
        BlockHitResult movingobjectpositionblock1 = voxelshape1.clip(vec3d, vec3d1, blockposition);
        double d0 = movingobjectpositionblock == null ? Double.MAX_VALUE : raytrace1.getFrom().distanceToSqr(movingobjectpositionblock.getLocation());
        double d1 = movingobjectpositionblock1 == null ? Double.MAX_VALUE : raytrace1.getFrom().distanceToSqr(movingobjectpositionblock1.getLocation());
        return d0 <= d1 ? movingobjectpositionblock : movingobjectpositionblock1;
    }

    default public BlockHitResult clip(ClipContext raytrace) {
        return BlockGetter.traverseBlocks(raytrace.getFrom(), raytrace.getTo(), raytrace, (raytrace1, blockposition) -> this.clip((ClipContext)raytrace1, (BlockPos)blockposition), raytrace1 -> {
            Vec3 vec3d = raytrace1.getFrom().subtract(raytrace1.getTo());
            return BlockHitResult.miss(raytrace1.getTo(), Direction.getApproximateNearest(vec3d.x, vec3d.y, vec3d.z), BlockPos.containing(raytrace1.getTo()));
        });
    }

    default public @Nullable BlockHitResult clipWithInteractionOverride(Vec3 vec3d, Vec3 vec3d1, BlockPos blockposition, VoxelShape voxelshape, BlockState iblockdata) {
        BlockHitResult movingobjectpositionblock1;
        BlockHitResult movingobjectpositionblock = voxelshape.clip(vec3d, vec3d1, blockposition);
        if (movingobjectpositionblock != null && (movingobjectpositionblock1 = iblockdata.getInteractionShape(this, blockposition).clip(vec3d, vec3d1, blockposition)) != null && movingobjectpositionblock1.getLocation().subtract(vec3d).lengthSqr() < movingobjectpositionblock.getLocation().subtract(vec3d).lengthSqr()) {
            return movingobjectpositionblock.withDirection(movingobjectpositionblock1.getDirection());
        }
        return movingobjectpositionblock;
    }

    default public double getBlockFloorHeight(VoxelShape voxelshape, Supplier<VoxelShape> supplier) {
        if (!voxelshape.isEmpty()) {
            return voxelshape.max(Direction.Axis.Y);
        }
        double d0 = supplier.get().max(Direction.Axis.Y);
        return d0 >= 1.0 ? d0 - 1.0 : Double.NEGATIVE_INFINITY;
    }

    default public double getBlockFloorHeight(BlockPos blockposition) {
        return this.getBlockFloorHeight(this.getBlockState(blockposition).getCollisionShape(this, blockposition), () -> {
            BlockPos blockposition1 = blockposition.below();
            return this.getBlockState(blockposition1).getCollisionShape(this, blockposition1);
        });
    }

    public static <T, C> T traverseBlocks(Vec3 vec3d, Vec3 vec3d1, C c0, BiFunction<C, BlockPos, @Nullable T> bifunction, Function<C, T> function) {
        int k;
        int j;
        if (vec3d.equals(vec3d1)) {
            return function.apply(c0);
        }
        double d0 = Mth.lerp(-1.0E-7, vec3d1.x, vec3d.x);
        double d1 = Mth.lerp(-1.0E-7, vec3d1.y, vec3d.y);
        double d2 = Mth.lerp(-1.0E-7, vec3d1.z, vec3d.z);
        double d3 = Mth.lerp(-1.0E-7, vec3d.x, vec3d1.x);
        double d4 = Mth.lerp(-1.0E-7, vec3d.y, vec3d1.y);
        double d5 = Mth.lerp(-1.0E-7, vec3d.z, vec3d1.z);
        int i = Mth.floor(d3);
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos(i, j = Mth.floor(d4), k = Mth.floor(d5));
        T t0 = bifunction.apply(c0, blockposition_mutableblockposition);
        if (t0 != null) {
            return t0;
        }
        double d6 = d0 - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        int l = Mth.sign(d6);
        int i1 = Mth.sign(d7);
        int j1 = Mth.sign(d8);
        double d9 = l == 0 ? Double.MAX_VALUE : (double)l / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / d8;
        double d12 = d9 * (l > 0 ? 1.0 - Mth.frac(d3) : Mth.frac(d3));
        double d13 = d10 * (i1 > 0 ? 1.0 - Mth.frac(d4) : Mth.frac(d4));
        double d14 = d11 * (j1 > 0 ? 1.0 - Mth.frac(d5) : Mth.frac(d5));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    i += l;
                    d12 += d9;
                } else {
                    k += j1;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                j += i1;
                d13 += d10;
            } else {
                k += j1;
                d14 += d11;
            }
            if ((t1 = bifunction.apply(c0, blockposition_mutableblockposition.set(i, j, k))) == null) continue;
            return t1;
        }
        return function.apply(c0);
    }

    public static boolean forEachBlockIntersectedBetween(Vec3 vec3d, Vec3 vec3d1, AABB axisalignedbb, BlockStepVisitor iblockaccess_a) {
        Vec3 vec3d2 = vec3d1.subtract(vec3d);
        if (vec3d2.lengthSqr() < (double)Mth.square(1.0E-5f)) {
            for (BlockPos blockposition : BlockPos.betweenClosed(axisalignedbb)) {
                if (iblockaccess_a.visit(blockposition, 0)) continue;
                return false;
            }
            return true;
        }
        LongOpenHashSet longset = new LongOpenHashSet();
        for (BlockPos blockposition1 : BlockPos.betweenCornersInDirection(axisalignedbb.move(vec3d2.scale(-1.0)), vec3d2)) {
            if (!iblockaccess_a.visit(blockposition1, 0)) {
                return false;
            }
            longset.add(blockposition1.asLong());
        }
        int i = BlockGetter.addCollisionsAlongTravel((LongSet)longset, vec3d2, axisalignedbb, iblockaccess_a);
        if (i < 0) {
            return false;
        }
        for (BlockPos blockposition2 : BlockPos.betweenCornersInDirection(axisalignedbb, vec3d2)) {
            if (!longset.add(blockposition2.asLong()) || iblockaccess_a.visit(blockposition2, i + 1)) continue;
            return false;
        }
        return true;
    }

    private static int addCollisionsAlongTravel(LongSet longset, Vec3 vec3d, AABB axisalignedbb, BlockStepVisitor iblockaccess_a) {
        double d0 = axisalignedbb.getXsize();
        double d1 = axisalignedbb.getYsize();
        double d2 = axisalignedbb.getZsize();
        Vec3i baseblockposition = BlockGetter.getFurthestCorner(vec3d);
        Vec3 vec3d1 = axisalignedbb.getCenter();
        Vec3 vec3d2 = new Vec3(vec3d1.x() + d0 * 0.5 * (double)baseblockposition.getX(), vec3d1.y() + d1 * 0.5 * (double)baseblockposition.getY(), vec3d1.z() + d2 * 0.5 * (double)baseblockposition.getZ());
        Vec3 vec3d3 = vec3d2.subtract(vec3d);
        int i = Mth.floor(vec3d3.x);
        int j = Mth.floor(vec3d3.y);
        int k = Mth.floor(vec3d3.z);
        int l = Mth.sign(vec3d.x);
        int i1 = Mth.sign(vec3d.y);
        int j1 = Mth.sign(vec3d.z);
        double d3 = l == 0 ? Double.MAX_VALUE : (double)l / vec3d.x;
        double d4 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / vec3d.y;
        double d5 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / vec3d.z;
        double d6 = d3 * (l > 0 ? 1.0 - Mth.frac(vec3d3.x) : Mth.frac(vec3d3.x));
        double d7 = d4 * (i1 > 0 ? 1.0 - Mth.frac(vec3d3.y) : Mth.frac(vec3d3.y));
        double d8 = d5 * (j1 > 0 ? 1.0 - Mth.frac(vec3d3.z) : Mth.frac(vec3d3.z));
        int k1 = 0;
        while (d6 <= 1.0 || d7 <= 1.0 || d8 <= 1.0) {
            Optional<Vec3> optional;
            if (d6 < d7) {
                if (d6 < d8) {
                    i += l;
                    d6 += d3;
                } else {
                    k += j1;
                    d8 += d5;
                }
            } else if (d7 < d8) {
                j += i1;
                d7 += d4;
            } else {
                k += j1;
                d8 += d5;
            }
            if ((optional = AABB.clip(i, j, k, i + 1, j + 1, k + 1, vec3d3, vec3d2)).isEmpty()) continue;
            Vec3 vec3d4 = optional.get();
            double d9 = Mth.clamp(vec3d4.x, (double)i + (double)1.0E-5f, (double)i + 1.0 - (double)1.0E-5f);
            double d10 = Mth.clamp(vec3d4.y, (double)j + (double)1.0E-5f, (double)j + 1.0 - (double)1.0E-5f);
            double d11 = Mth.clamp(vec3d4.z, (double)k + (double)1.0E-5f, (double)k + 1.0 - (double)1.0E-5f);
            int l1 = Mth.floor(d9 - d0 * (double)baseblockposition.getX());
            int i2 = Mth.floor(d10 - d1 * (double)baseblockposition.getY());
            int j2 = Mth.floor(d11 - d2 * (double)baseblockposition.getZ());
            int k2 = ++k1;
            for (BlockPos blockposition : BlockPos.betweenCornersInDirection(i, j, k, l1, i2, j2, vec3d)) {
                if (!longset.add(blockposition.asLong()) || iblockaccess_a.visit(blockposition, k2)) continue;
                return -1;
            }
        }
        return k1;
    }

    private static Vec3i getFurthestCorner(Vec3 vec3d) {
        int k;
        double d0 = Math.abs(Vec3.X_AXIS.dot(vec3d));
        double d1 = Math.abs(Vec3.Y_AXIS.dot(vec3d));
        double d2 = Math.abs(Vec3.Z_AXIS.dot(vec3d));
        int i = vec3d.x >= 0.0 ? 1 : -1;
        int j = vec3d.y >= 0.0 ? 1 : -1;
        int n = k = vec3d.z >= 0.0 ? 1 : -1;
        return d0 <= d1 && d0 <= d2 ? new Vec3i(-i, -k, j) : (d1 <= d2 ? new Vec3i(k, -j, -i) : new Vec3i(-j, i, -k));
    }

    @FunctionalInterface
    public static interface BlockStepVisitor {
        public boolean visit(BlockPos var1, int var2);
    }
}

