/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockCollisions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public interface CollisionGetter
extends BlockGetter {
    public WorldBorder getWorldBorder();

    public @Nullable BlockGetter getChunkForCollisions(int var1, int var2);

    default public boolean isUnobstructed(@Nullable Entity var0, VoxelShape var1) {
        return true;
    }

    default public boolean isUnobstructed(BlockState var0, BlockPos var1, CollisionContext var2) {
        VoxelShape var3 = var0.getCollisionShape(this, var1, var2);
        return var3.isEmpty() || this.isUnobstructed(null, var3.move(var1));
    }

    default public boolean isUnobstructed(Entity var0) {
        return this.isUnobstructed(var0, Shapes.create(var0.getBoundingBox()));
    }

    default public boolean noCollision(AABB var0) {
        return this.noCollision(null, var0);
    }

    default public boolean noCollision(Entity var0) {
        return this.noCollision(var0, var0.getBoundingBox());
    }

    default public boolean noCollision(@Nullable Entity var0, AABB var1) {
        return this.noCollision(var0, var1, false);
    }

    default public boolean noCollision(@Nullable Entity var0, AABB var1, boolean var2) {
        return this.noBlockCollision(var0, var1, var2) && this.noEntityCollision(var0, var1) && this.noBorderCollision(var0, var1);
    }

    default public boolean noBlockCollision(@Nullable Entity var0, AABB var1) {
        return this.noBlockCollision(var0, var1, false);
    }

    default public boolean noBlockCollision(@Nullable Entity var0, AABB var1, boolean var2) {
        Iterable<VoxelShape> var3 = var2 ? this.getBlockAndLiquidCollisions(var0, var1) : this.getBlockCollisions(var0, var1);
        for (VoxelShape var5 : var3) {
            if (var5.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public boolean noEntityCollision(@Nullable Entity var0, AABB var1) {
        return this.getEntityCollisions(var0, var1).isEmpty();
    }

    default public boolean noBorderCollision(@Nullable Entity var0, AABB var1) {
        if (var0 != null) {
            VoxelShape var2 = this.borderCollision(var0, var1);
            return var2 == null || !Shapes.joinIsNotEmpty(var2, Shapes.create(var1), BooleanOp.AND);
        }
        return true;
    }

    public List<VoxelShape> getEntityCollisions(@Nullable Entity var1, AABB var2);

    default public Iterable<VoxelShape> getCollisions(@Nullable Entity var0, AABB var1) {
        List<VoxelShape> var2 = this.getEntityCollisions(var0, var1);
        Iterable var3 = this.getBlockCollisions(var0, var1);
        return var2.isEmpty() ? var3 : Iterables.concat(var2, var3);
    }

    default public Iterable<VoxelShape> getPreMoveCollisions(@Nullable Entity var0, AABB var1, Vec3 var2) {
        List<VoxelShape> var3 = this.getEntityCollisions(var0, var1);
        Iterable var4 = this.getBlockCollisionsFromContext(CollisionContext.withPosition(var0, var2.y), var1);
        return var3.isEmpty() ? var4 : Iterables.concat(var3, var4);
    }

    default public Iterable<VoxelShape> getBlockCollisions(@Nullable Entity var0, AABB var1) {
        return this.getBlockCollisionsFromContext(var0 == null ? CollisionContext.empty() : CollisionContext.of(var0), var1);
    }

    default public Iterable<VoxelShape> getBlockAndLiquidCollisions(@Nullable Entity var0, AABB var1) {
        return this.getBlockCollisionsFromContext(var0 == null ? CollisionContext.emptyWithFluidCollisions() : CollisionContext.of(var0, true), var1);
    }

    private Iterable<VoxelShape> getBlockCollisionsFromContext(CollisionContext var0, AABB var1) {
        return () -> new BlockCollisions<VoxelShape>(this, var0, var1, false, (var0, var1) -> var1);
    }

    private @Nullable VoxelShape borderCollision(Entity var0, AABB var1) {
        WorldBorder var2 = this.getWorldBorder();
        return var2.isInsideCloseToBorder(var0, var1) ? var2.getCollisionShape() : null;
    }

    default public BlockHitResult clipIncludingBorder(ClipContext var0) {
        BlockHitResult var1 = this.clip(var0);
        WorldBorder var2 = this.getWorldBorder();
        if (var2.isWithinBounds(var0.getFrom()) && !var2.isWithinBounds(var1.getLocation())) {
            Vec3 var3 = var1.getLocation().subtract(var0.getFrom());
            Direction var4 = Direction.getApproximateNearest(var3.x, var3.y, var3.z);
            Vec3 var5 = var2.clampVec3ToBound(var1.getLocation());
            return new BlockHitResult(var5, var4, BlockPos.containing(var5), false, true);
        }
        return var1;
    }

    default public boolean collidesWithSuffocatingBlock(@Nullable Entity var02, AABB var12) {
        BlockCollisions<VoxelShape> var2 = new BlockCollisions<VoxelShape>(this, var02, var12, true, (var0, var1) -> var1);
        while (var2.hasNext()) {
            if (((VoxelShape)var2.next()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    default public Optional<BlockPos> findSupportingBlock(Entity var02, AABB var12) {
        BlockPos var2 = null;
        double var3 = Double.MAX_VALUE;
        BlockCollisions<BlockPos> var5 = new BlockCollisions<BlockPos>(this, var02, var12, false, (var0, var1) -> var0);
        while (var5.hasNext()) {
            BlockPos var6 = (BlockPos)var5.next();
            double var7 = var6.distToCenterSqr(var02.position());
            if (!(var7 < var3) && (var7 != var3 || var2 != null && var2.compareTo(var6) >= 0)) continue;
            var2 = var6.immutable();
            var3 = var7;
        }
        return Optional.ofNullable(var2);
    }

    default public Optional<Vec3> findFreePosition(@Nullable Entity var02, VoxelShape var1, Vec3 var2, double var3, double var5, double var7) {
        if (var1.isEmpty()) {
            return Optional.empty();
        }
        AABB var9 = var1.bounds().inflate(var3, var5, var7);
        VoxelShape var10 = StreamSupport.stream(this.getBlockCollisions(var02, var9).spliterator(), false).filter(var0 -> this.getWorldBorder() == null || this.getWorldBorder().isWithinBounds(var0.bounds())).flatMap(var0 -> var0.toAabbs().stream()).map(var6 -> var6.inflate(var3 / 2.0, var5 / 2.0, var7 / 2.0)).map(Shapes::create).reduce(Shapes.empty(), Shapes::or);
        VoxelShape var11 = Shapes.join(var1, var10, BooleanOp.ONLY_FIRST);
        return var11.closestPointTo(var2);
    }
}

