/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class ExplosionDamageCalculator {
    public Optional<Float> getBlockExplosionResistance(Explosion var0, BlockGetter var1, BlockPos var2, BlockState var3, FluidState var4) {
        if (var3.isAir() && var4.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(Math.max(var3.getBlock().getExplosionResistance(), var4.getExplosionResistance())));
    }

    public boolean shouldBlockExplode(Explosion var0, BlockGetter var1, BlockPos var2, BlockState var3, float var4) {
        return true;
    }

    public boolean shouldDamageEntity(Explosion var0, Entity var1) {
        return true;
    }

    public float getKnockbackMultiplier(Entity var0) {
        return 1.0f;
    }

    public float getEntityDamageAmount(Explosion var0, Entity var1, float var2) {
        float var3 = var0.radius() * 2.0f;
        Vec3 var4 = var0.center();
        double var5 = Math.sqrt(var1.distanceToSqr(var4)) / (double)var3;
        double var7 = (1.0 - var5) * (double)var2;
        return (float)((var7 * var7 + var7) / 2.0 * 7.0 * (double)var3 + 1.0);
    }
}

