/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.biome;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.levelgen.NoiseRouterData;

public class MultiNoiseBiomeSource
extends BiomeSource {
    private static final MapCodec<Holder<Biome>> ENTRY_CODEC = Biome.CODEC.fieldOf("biome");
    public static final MapCodec<Climate.ParameterList<Holder<Biome>>> DIRECT_CODEC = Climate.ParameterList.codec(ENTRY_CODEC).fieldOf("biomes");
    private static final MapCodec<Holder<MultiNoiseBiomeSourceParameterList>> PRESET_CODEC = MultiNoiseBiomeSourceParameterList.CODEC.fieldOf("preset").withLifecycle(Lifecycle.stable());
    public static final MapCodec<MultiNoiseBiomeSource> CODEC = Codec.mapEither(DIRECT_CODEC, PRESET_CODEC).xmap(MultiNoiseBiomeSource::new, var0 -> var0.parameters);
    private final Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>> parameters;

    private MultiNoiseBiomeSource(Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>> var0) {
        this.parameters = var0;
    }

    public static MultiNoiseBiomeSource createFromList(Climate.ParameterList<Holder<Biome>> var0) {
        return new MultiNoiseBiomeSource((Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>>)Either.left(var0));
    }

    public static MultiNoiseBiomeSource createFromPreset(Holder<MultiNoiseBiomeSourceParameterList> var0) {
        return new MultiNoiseBiomeSource((Either<Climate.ParameterList<Holder<Biome>>, Holder<MultiNoiseBiomeSourceParameterList>>)Either.right(var0));
    }

    private Climate.ParameterList<Holder<Biome>> parameters() {
        return (Climate.ParameterList)this.parameters.map(var0 -> var0, var0 -> ((MultiNoiseBiomeSourceParameterList)var0.value()).parameters());
    }

    @Override
    protected Stream<Holder<Biome>> collectPossibleBiomes() {
        return this.parameters().values().stream().map(Pair::getSecond);
    }

    @Override
    protected MapCodec<? extends BiomeSource> codec() {
        return CODEC;
    }

    public boolean stable(ResourceKey<MultiNoiseBiomeSourceParameterList> var0) {
        Optional var1 = this.parameters.right();
        return var1.isPresent() && ((Holder)var1.get()).is(var0);
    }

    @Override
    public Holder<Biome> getNoiseBiome(int var0, int var1, int var2, Climate.Sampler var3) {
        return this.getNoiseBiome(var3.sample(var0, var1, var2));
    }

    @VisibleForDebug
    public Holder<Biome> getNoiseBiome(Climate.TargetPoint var0) {
        return this.parameters().findValue(var0);
    }

    @Override
    public void addDebugInfo(List<String> var0, BlockPos var1, Climate.Sampler var2) {
        int var3 = QuartPos.fromBlock(var1.getX());
        int var4 = QuartPos.fromBlock(var1.getY());
        int var5 = QuartPos.fromBlock(var1.getZ());
        Climate.TargetPoint var6 = var2.sample(var3, var4, var5);
        float var7 = Climate.unquantizeCoord(var6.continentalness());
        float var8 = Climate.unquantizeCoord(var6.erosion());
        float var9 = Climate.unquantizeCoord(var6.temperature());
        float var10 = Climate.unquantizeCoord(var6.humidity());
        float var11 = Climate.unquantizeCoord(var6.weirdness());
        double var12 = NoiseRouterData.peaksAndValleys(var11);
        OverworldBiomeBuilder var14 = new OverworldBiomeBuilder();
        var0.add("Biome builder PV: " + OverworldBiomeBuilder.getDebugStringForPeaksAndValleys(var12) + " C: " + var14.getDebugStringForContinentalness(var7) + " E: " + var14.getDebugStringForErosion(var8) + " T: " + var14.getDebugStringForTemperature(var9) + " H: " + var14.getDebugStringForHumidity(var10));
    }
}

