/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;

public abstract class BaseEntityBlock
extends Block
implements EntityBlock {
    protected BaseEntityBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    protected abstract MapCodec<? extends BaseEntityBlock> codec();

    @Override
    protected boolean triggerEvent(BlockState var0, Level var1, BlockPos var2, int var3, int var4) {
        super.triggerEvent(var0, var1, var2, var3, var4);
        BlockEntity var5 = var1.getBlockEntity(var2);
        if (var5 == null) {
            return false;
        }
        return var5.triggerEvent(var3, var4);
    }

    @Override
    protected @Nullable MenuProvider getMenuProvider(BlockState var0, Level var1, BlockPos var2) {
        BlockEntity var3 = var1.getBlockEntity(var2);
        return var3 instanceof MenuProvider ? (MenuProvider)((Object)var3) : null;
    }

    protected static <E extends BlockEntity, A extends BlockEntity> @Nullable BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> var0, BlockEntityType<E> var1, BlockEntityTicker<? super E> var2) {
        return var1 == var0 ? var2 : null;
    }
}

