/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class BrushableBlock
extends BaseEntityBlock
implements Fallable {
    public static final MapCodec<BrushableBlock> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("turns_into").forGetter(BrushableBlock::getTurnsInto), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("brush_sound").forGetter(BrushableBlock::getBrushSound), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("brush_completed_sound").forGetter(BrushableBlock::getBrushCompletedSound), BrushableBlock.propertiesCodec()).apply((Applicative)var0, BrushableBlock::new));
    private static final IntegerProperty DUSTED = BlockStateProperties.DUSTED;
    public static final int TICK_DELAY = 2;
    private final Block turnsInto;
    private final SoundEvent brushSound;
    private final SoundEvent brushCompletedSound;

    public MapCodec<BrushableBlock> codec() {
        return CODEC;
    }

    public BrushableBlock(Block var0, SoundEvent var1, SoundEvent var2, BlockBehaviour.Properties var3) {
        super(var3);
        this.turnsInto = var0;
        this.brushSound = var1;
        this.brushCompletedSound = var2;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(DUSTED, 0));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(DUSTED);
    }

    @Override
    public void onPlace(BlockState var0, Level var1, BlockPos var2, BlockState var3, boolean var4) {
        var1.scheduleTick(var2, this, 2);
    }

    @Override
    public BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        var2.scheduleTick(var3, this, 2);
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    public void tick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        DebugValueSource var4;
        BlockEntity blockEntity = var1.getBlockEntity(var2);
        if (blockEntity instanceof BrushableBlockEntity) {
            var4 = (BrushableBlockEntity)blockEntity;
            ((BrushableBlockEntity)var4).checkReset(var1);
        }
        if (!FallingBlock.isFree(var1.getBlockState(var2.below())) || var2.getY() < var1.getMinY()) {
            return;
        }
        var4 = FallingBlockEntity.fall(var1, var2, var0);
        ((FallingBlockEntity)var4).disableDrop();
    }

    @Override
    public void onBrokenAfterFall(Level var0, BlockPos var1, FallingBlockEntity var2) {
        Vec3 var3 = var2.getBoundingBox().getCenter();
        var0.levelEvent(2001, BlockPos.containing(var3), Block.getId(var2.getBlockState()));
        var0.gameEvent((Entity)var2, GameEvent.BLOCK_DESTROY, var3);
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        BlockPos var4;
        if (var3.nextInt(16) == 0 && FallingBlock.isFree(var1.getBlockState(var4 = var2.below()))) {
            double var5 = (double)var2.getX() + var3.nextDouble();
            double var7 = (double)var2.getY() - 0.05;
            double var9 = (double)var2.getZ() + var3.nextDouble();
            var1.addParticle(new BlockParticleOption(ParticleTypes.FALLING_DUST, var0), var5, var7, var9, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public @Nullable BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return new BrushableBlockEntity(var0, var1);
    }

    public Block getTurnsInto() {
        return this.turnsInto;
    }

    public SoundEvent getBrushSound() {
        return this.brushSound;
    }

    public SoundEvent getBrushCompletedSound() {
        return this.brushCompletedSound;
    }
}

