/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class BubbleColumnBlock
extends Block
implements BucketPickup {
    public static final MapCodec<BubbleColumnBlock> CODEC = BubbleColumnBlock.simpleCodec(BubbleColumnBlock::new);
    public static final BooleanProperty DRAG_DOWN = BlockStateProperties.DRAG;
    private static final int CHECK_PERIOD = 5;

    public MapCodec<BubbleColumnBlock> codec() {
        return CODEC;
    }

    public BubbleColumnBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(DRAG_DOWN, true));
    }

    @Override
    protected void entityInside(BlockState var0, Level var1, BlockPos var2, Entity var3, InsideBlockEffectApplier var4, boolean var5) {
        if (var5) {
            boolean var7;
            BlockState var6 = var1.getBlockState(var2.above());
            boolean bl = var7 = var6.getCollisionShape(var1, var2).isEmpty() && var6.getFluidState().isEmpty();
            if (var7) {
                var3.onAboveBubbleColumn(var0.getValue(DRAG_DOWN), var2);
            } else {
                var3.onInsideBubbleColumn(var0.getValue(DRAG_DOWN));
            }
        }
    }

    @Override
    protected void tick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        BubbleColumnBlock.updateColumn(var1, var2, var0, var1.getBlockState(var2.below()));
    }

    @Override
    protected FluidState getFluidState(BlockState var0) {
        return Fluids.WATER.getSource(false);
    }

    public static void updateColumn(LevelAccessor var0, BlockPos var1, BlockState var2) {
        BubbleColumnBlock.updateColumn(var0, var1, var0.getBlockState(var1), var2);
    }

    public static void updateColumn(LevelAccessor var0, BlockPos var1, BlockState var2, BlockState var3) {
        if (!BubbleColumnBlock.canExistIn(var2)) {
            return;
        }
        BlockState var4 = BubbleColumnBlock.getColumnState(var3);
        var0.setBlock(var1, var4, 2);
        BlockPos.MutableBlockPos var5 = var1.mutable().move(Direction.UP);
        while (BubbleColumnBlock.canExistIn(var0.getBlockState(var5))) {
            if (!var0.setBlock(var5, var4, 2)) {
                return;
            }
            var5.move(Direction.UP);
        }
    }

    private static boolean canExistIn(BlockState var0) {
        return var0.is(Blocks.BUBBLE_COLUMN) || var0.is(Blocks.WATER) && var0.getFluidState().getAmount() >= 8 && var0.getFluidState().isSource();
    }

    private static BlockState getColumnState(BlockState var0) {
        if (var0.is(Blocks.BUBBLE_COLUMN)) {
            return var0;
        }
        if (var0.is(Blocks.SOUL_SAND)) {
            return (BlockState)Blocks.BUBBLE_COLUMN.defaultBlockState().setValue(DRAG_DOWN, false);
        }
        if (var0.is(Blocks.MAGMA_BLOCK)) {
            return (BlockState)Blocks.BUBBLE_COLUMN.defaultBlockState().setValue(DRAG_DOWN, true);
        }
        return Blocks.WATER.defaultBlockState();
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        double var4 = var2.getX();
        double var6 = var2.getY();
        double var8 = var2.getZ();
        if (var0.getValue(DRAG_DOWN).booleanValue()) {
            var1.addAlwaysVisibleParticle(ParticleTypes.CURRENT_DOWN, var4 + 0.5, var6 + 0.8, var8, 0.0, 0.0, 0.0);
            if (var3.nextInt(200) == 0) {
                var1.playLocalSound(var4, var6, var8, SoundEvents.BUBBLE_COLUMN_WHIRLPOOL_AMBIENT, SoundSource.BLOCKS, 0.2f + var3.nextFloat() * 0.2f, 0.9f + var3.nextFloat() * 0.15f, false);
            }
        } else {
            var1.addAlwaysVisibleParticle(ParticleTypes.BUBBLE_COLUMN_UP, var4 + 0.5, var6, var8 + 0.5, 0.0, 0.04, 0.0);
            var1.addAlwaysVisibleParticle(ParticleTypes.BUBBLE_COLUMN_UP, var4 + (double)var3.nextFloat(), var6 + (double)var3.nextFloat(), var8 + (double)var3.nextFloat(), 0.0, 0.04, 0.0);
            if (var3.nextInt(200) == 0) {
                var1.playLocalSound(var4, var6, var8, SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.BLOCKS, 0.2f + var3.nextFloat() * 0.2f, 0.9f + var3.nextFloat() * 0.15f, false);
            }
        }
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        var2.scheduleTick(var3, Fluids.WATER, Fluids.WATER.getTickDelay(var1));
        if (!var0.canSurvive(var1, var3) || var4 == Direction.DOWN || var4 == Direction.UP && !var6.is(Blocks.BUBBLE_COLUMN) && BubbleColumnBlock.canExistIn(var6)) {
            var2.scheduleTick(var3, this, 5);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        BlockState var3 = var1.getBlockState(var2.below());
        return var3.is(Blocks.BUBBLE_COLUMN) || var3.is(Blocks.MAGMA_BLOCK) || var3.is(Blocks.SOUL_SAND);
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return Shapes.empty();
    }

    @Override
    protected RenderShape getRenderShape(BlockState var0) {
        return RenderShape.INVISIBLE;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(DRAG_DOWN);
    }

    @Override
    public ItemStack pickupBlock(@Nullable LivingEntity var0, LevelAccessor var1, BlockPos var2, BlockState var3) {
        var1.setBlock(var2, Blocks.AIR.defaultBlockState(), 11);
        return new ItemStack(Items.WATER_BUCKET);
    }

    @Override
    public Optional<SoundEvent> getPickupSound() {
        return Fluids.WATER.getPickupSound();
    }
}

