/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CandleCakeBlock
extends AbstractCandleBlock {
    public static final MapCodec<CandleCakeBlock> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("candle").forGetter(var0 -> var0.candleBlock), CandleCakeBlock.propertiesCodec()).apply((Applicative)var02, CandleCakeBlock::new));
    public static final BooleanProperty LIT = AbstractCandleBlock.LIT;
    private static final VoxelShape SHAPE = Shapes.or(Block.column(2.0, 8.0, 14.0), Block.column(14.0, 0.0, 8.0));
    private static final Map<CandleBlock, CandleCakeBlock> BY_CANDLE = Maps.newHashMap();
    private static final Iterable<Vec3> PARTICLE_OFFSETS = List.of(new Vec3(8.0, 16.0, 8.0).scale(0.0625));
    private final CandleBlock candleBlock;

    public MapCodec<CandleCakeBlock> codec() {
        return CODEC;
    }

    protected CandleCakeBlock(Block var0, BlockBehaviour.Properties var1) {
        super(var1);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(LIT, false));
        if (!(var0 instanceof CandleBlock)) {
            throw new IllegalArgumentException("Expected block to be of " + String.valueOf(CandleBlock.class) + " was " + String.valueOf(var0.getClass()));
        }
        CandleBlock var2 = (CandleBlock)var0;
        BY_CANDLE.put(var2, this);
        this.candleBlock = var2;
    }

    @Override
    protected Iterable<Vec3> getParticleOffsets(BlockState var0) {
        return PARTICLE_OFFSETS;
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return SHAPE;
    }

    @Override
    protected InteractionResult useItemOn(ItemStack var0, BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, BlockHitResult var6) {
        if (var0.is(Items.FLINT_AND_STEEL) || var0.is(Items.FIRE_CHARGE)) {
            return InteractionResult.PASS;
        }
        if (CandleCakeBlock.candleHit(var6) && var0.isEmpty() && var1.getValue(LIT).booleanValue()) {
            CandleCakeBlock.extinguish(var4, var1, var2, var3);
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(var0, var1, var2, var3, var4, var5, var6);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState var0, Level var1, BlockPos var2, Player var3, BlockHitResult var4) {
        InteractionResult var5 = CakeBlock.eat(var1, var2, Blocks.CAKE.defaultBlockState(), var3);
        if (var5.consumesAction()) {
            CandleCakeBlock.dropResources(var0, var1, var2);
        }
        return var5;
    }

    private static boolean candleHit(BlockHitResult var0) {
        return var0.getLocation().y - (double)var0.getBlockPos().getY() > 0.5;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(LIT);
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader var0, BlockPos var1, BlockState var2, boolean var3) {
        return new ItemStack(Blocks.CAKE);
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var4 == Direction.DOWN && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        return var1.getBlockState(var2.below()).isSolid();
    }

    @Override
    protected int getAnalogOutputSignal(BlockState var0, Level var1, BlockPos var2, Direction var3) {
        return CakeBlock.FULL_CAKE_SIGNAL;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState var0) {
        return true;
    }

    @Override
    protected boolean isPathfindable(BlockState var0, PathComputationType var1) {
        return false;
    }

    public static BlockState byCandle(CandleBlock var0) {
        return BY_CANDLE.get(var0).defaultBlockState();
    }

    public static boolean canLight(BlockState var0) {
        return var0.is(BlockTags.CANDLE_CAKES, var1 -> var1.hasProperty(LIT) && var0.getValue(LIT) == false);
    }
}

