/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.animal.feline.Cat;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class ChestBlock
extends AbstractChestBlock<ChestBlockEntity>
implements SimpleWaterloggedBlock {
    public static final MapCodec<ChestBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("open_sound").forGetter(ChestBlock::getOpenChestSound), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("close_sound").forGetter(ChestBlock::getCloseChestSound), ChestBlock.propertiesCodec()).apply((Applicative)instance, (soundeffect, soundeffect1, blockbase_info) -> new ChestBlock(() -> BlockEntityType.CHEST, (SoundEvent)soundeffect, (SoundEvent)soundeffect1, (BlockBehaviour.Properties)blockbase_info)));
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<ChestType> TYPE = BlockStateProperties.CHEST_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final int EVENT_SET_OPEN_COUNT = 1;
    private static final VoxelShape SHAPE = Block.column(14.0, 0.0, 14.0);
    private static final Map<Direction, VoxelShape> HALF_SHAPES = Shapes.rotateHorizontal(Block.boxZ(14.0, 0.0, 14.0, 0.0, 15.0));
    private final SoundEvent openSound;
    private final SoundEvent closeSound;
    private static final DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<Container>> CHEST_COMBINER = new DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<Container>>(){

        @Override
        public Optional<Container> acceptDouble(ChestBlockEntity tileentitychest, ChestBlockEntity tileentitychest1) {
            return Optional.of(new CompoundContainer(tileentitychest, tileentitychest1));
        }

        @Override
        public Optional<Container> acceptSingle(ChestBlockEntity tileentitychest) {
            return Optional.of(tileentitychest);
        }

        @Override
        public Optional<Container> acceptNone() {
            return Optional.empty();
        }
    };
    public static final DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>> MENU_PROVIDER_COMBINER = new DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>>(){

        @Override
        public Optional<MenuProvider> acceptDouble(ChestBlockEntity tileentitychest, ChestBlockEntity tileentitychest1) {
            CompoundContainer iinventory = new CompoundContainer(tileentitychest, tileentitychest1);
            return Optional.of(new DoubleInventory(tileentitychest, tileentitychest1, iinventory));
        }

        @Override
        public Optional<MenuProvider> acceptSingle(ChestBlockEntity tileentitychest) {
            return Optional.of(tileentitychest);
        }

        @Override
        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };

    @Override
    public MapCodec<? extends ChestBlock> codec() {
        return CODEC;
    }

    protected ChestBlock(Supplier<BlockEntityType<? extends ChestBlockEntity>> supplier, SoundEvent soundeffect, SoundEvent soundeffect1, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info, supplier);
        this.openSound = soundeffect;
        this.closeSound = soundeffect1;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(TYPE, ChestType.SINGLE)).setValue(WATERLOGGED, false));
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState iblockdata) {
        ChestType blockpropertychesttype = iblockdata.getValue(TYPE);
        return blockpropertychesttype == ChestType.SINGLE ? DoubleBlockCombiner.BlockType.SINGLE : (blockpropertychesttype == ChestType.RIGHT ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND);
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            scheduledtickaccess.scheduleTick(blockposition, Fluids.WATER, Fluids.WATER.getTickDelay(iworldreader));
        }
        if (this.chestCanConnectTo(iblockdata1) && enumdirection.getAxis().isHorizontal()) {
            ChestType blockpropertychesttype = iblockdata1.getValue(TYPE);
            if (iblockdata.getValue(TYPE) == ChestType.SINGLE && blockpropertychesttype != ChestType.SINGLE && iblockdata.getValue(FACING) == iblockdata1.getValue(FACING) && ChestBlock.getConnectedDirection(iblockdata1) == enumdirection.getOpposite()) {
                return (BlockState)iblockdata.setValue(TYPE, blockpropertychesttype.getOpposite());
            }
        } else if (ChestBlock.getConnectedDirection(iblockdata) == enumdirection) {
            return (BlockState)iblockdata.setValue(TYPE, ChestType.SINGLE);
        }
        return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    public boolean chestCanConnectTo(BlockState iblockdata) {
        return iblockdata.is(this);
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return switch (iblockdata.getValue(TYPE)) {
            case ChestType.SINGLE -> SHAPE;
            case ChestType.LEFT, ChestType.RIGHT -> HALF_SHAPES.get(ChestBlock.getConnectedDirection(iblockdata));
            default -> throw new MatchException(null, null);
        };
    }

    public static Direction getConnectedDirection(BlockState iblockdata) {
        Direction enumdirection = iblockdata.getValue(FACING);
        return iblockdata.getValue(TYPE) == ChestType.LEFT ? enumdirection.getClockWise() : enumdirection.getCounterClockWise();
    }

    public static BlockPos getConnectedBlockPos(BlockPos blockposition, BlockState iblockdata) {
        Direction enumdirection = ChestBlock.getConnectedDirection(iblockdata);
        return blockposition.relative(enumdirection);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        Direction enumdirection2;
        ChestType blockpropertychesttype = ChestType.SINGLE;
        Direction enumdirection = blockactioncontext.getHorizontalDirection().getOpposite();
        FluidState fluid = blockactioncontext.getLevel().getFluidState(blockactioncontext.getClickedPos());
        boolean flag = blockactioncontext.isSecondaryUseActive();
        Direction enumdirection1 = blockactioncontext.getClickedFace();
        if (enumdirection1.getAxis().isHorizontal() && flag && (enumdirection2 = this.candidatePartnerFacing(blockactioncontext.getLevel(), blockactioncontext.getClickedPos(), enumdirection1.getOpposite())) != null && enumdirection2.getAxis() != enumdirection1.getAxis()) {
            enumdirection = enumdirection2;
            ChestType chestType = blockpropertychesttype = enumdirection2.getCounterClockWise() == enumdirection1.getOpposite() ? ChestType.RIGHT : ChestType.LEFT;
        }
        if (blockpropertychesttype == ChestType.SINGLE && !flag) {
            blockpropertychesttype = this.getChestType(blockactioncontext.getLevel(), blockactioncontext.getClickedPos(), enumdirection);
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, enumdirection)).setValue(TYPE, blockpropertychesttype)).setValue(WATERLOGGED, fluid.getType() == Fluids.WATER);
    }

    protected ChestType getChestType(Level world, BlockPos blockposition, Direction enumdirection) {
        return enumdirection == this.candidatePartnerFacing(world, blockposition, enumdirection.getClockWise()) ? ChestType.LEFT : (enumdirection == this.candidatePartnerFacing(world, blockposition, enumdirection.getCounterClockWise()) ? ChestType.RIGHT : ChestType.SINGLE);
    }

    @Override
    protected FluidState getFluidState(BlockState iblockdata) {
        return iblockdata.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(iblockdata);
    }

    private @Nullable Direction candidatePartnerFacing(Level world, BlockPos blockposition, Direction enumdirection) {
        BlockState iblockdata = world.getBlockState(blockposition.relative(enumdirection));
        return this.chestCanConnectTo(iblockdata) && iblockdata.getValue(TYPE) == ChestType.SINGLE ? iblockdata.getValue(FACING) : null;
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, boolean flag) {
        Containers.updateNeighboursAfterDestroy(iblockdata, worldserver, blockposition);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            MenuProvider itileinventory = this.getMenuProvider(iblockdata, world, blockposition);
            if (itileinventory != null) {
                entityhuman.openMenu(itileinventory);
                entityhuman.awardStat(this.getOpenChestStat());
                PiglinAi.angerNearbyPiglins(worldserver, entityhuman, true);
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected Stat<Identifier> getOpenChestStat() {
        return Stats.CUSTOM.get(Stats.OPEN_CHEST);
    }

    public BlockEntityType<? extends ChestBlockEntity> blockEntityType() {
        return (BlockEntityType)this.blockEntityType.get();
    }

    public static @Nullable Container getContainer(ChestBlock blockchest, BlockState iblockdata, Level world, BlockPos blockposition, boolean flag) {
        return blockchest.combine(iblockdata, world, blockposition, flag).apply(CHEST_COMBINER).orElse(null);
    }

    @Override
    public DoubleBlockCombiner.NeighborCombineResult<? extends ChestBlockEntity> combine(BlockState iblockdata, Level world, BlockPos blockposition, boolean flag) {
        BiPredicate<LevelAccessor, BlockPos> bipredicate = flag ? (generatoraccess, blockposition1) -> false : ChestBlock::isChestBlockedAt;
        return DoubleBlockCombiner.combineWithNeigbour((BlockEntityType)this.blockEntityType.get(), ChestBlock::getBlockType, ChestBlock::getConnectedDirection, FACING, iblockdata, world, blockposition, bipredicate);
    }

    @Override
    protected @Nullable MenuProvider getMenuProvider(BlockState iblockdata, Level world, BlockPos blockposition) {
        return this.getMenuProvider(iblockdata, world, blockposition, false);
    }

    public @Nullable MenuProvider getMenuProvider(BlockState iblockdata, Level world, BlockPos blockposition, boolean ignoreObstructions) {
        return this.combine(iblockdata, world, blockposition, ignoreObstructions).apply(MENU_PROVIDER_COMBINER).orElse(null);
    }

    public static DoubleBlockCombiner.Combiner<ChestBlockEntity, Float2FloatFunction> opennessCombiner(final LidBlockEntity lidblockentity) {
        return new DoubleBlockCombiner.Combiner<ChestBlockEntity, Float2FloatFunction>(){

            @Override
            public Float2FloatFunction acceptDouble(ChestBlockEntity tileentitychest, ChestBlockEntity tileentitychest1) {
                return f -> Math.max(tileentitychest.getOpenNess(f), tileentitychest1.getOpenNess(f));
            }

            @Override
            public Float2FloatFunction acceptSingle(ChestBlockEntity tileentitychest) {
                Objects.requireNonNull(tileentitychest);
                return tileentitychest::getOpenNess;
            }

            @Override
            public Float2FloatFunction acceptNone() {
                LidBlockEntity lidblockentity1 = lidblockentity;
                Objects.requireNonNull(lidblockentity);
                return lidblockentity1::getOpenNess;
            }
        };
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        return new ChestBlockEntity(blockposition, iblockdata);
    }

    @Override
    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> getTicker(Level world, BlockState iblockdata, BlockEntityType<T> tileentitytypes) {
        return world.isClientSide() ? ChestBlock.createTickerHelper(tileentitytypes, this.blockEntityType(), ChestBlockEntity::lidAnimateTick) : null;
    }

    public static boolean isChestBlockedAt(LevelAccessor generatoraccess, BlockPos blockposition) {
        return ChestBlock.isBlockedChestByBlock(generatoraccess, blockposition) || ChestBlock.isCatSittingOnChest(generatoraccess, blockposition);
    }

    private static boolean isBlockedChestByBlock(BlockGetter iblockaccess, BlockPos blockposition) {
        BlockPos blockposition1 = blockposition.above();
        return iblockaccess.getBlockState(blockposition1).isRedstoneConductor(iblockaccess, blockposition1);
    }

    private static boolean isCatSittingOnChest(LevelAccessor generatoraccess, BlockPos blockposition) {
        List<Cat> list = generatoraccess.getEntitiesOfClass(Cat.class, new AABB(blockposition.getX(), blockposition.getY() + 1, blockposition.getZ(), blockposition.getX() + 1, blockposition.getY() + 2, blockposition.getZ() + 1));
        if (!list.isEmpty()) {
            for (Cat entitycat : list) {
                if (!entitycat.isInSittingPose()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState iblockdata) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState iblockdata, Level world, BlockPos blockposition, Direction enumdirection) {
        return AbstractContainerMenu.getRedstoneSignalFromContainer(ChestBlock.getContainer(this, iblockdata, world, blockposition, false));
    }

    @Override
    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        return (BlockState)iblockdata.setValue(FACING, enumblockrotation.rotate(iblockdata.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation(iblockdata.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(FACING, TYPE, WATERLOGGED);
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        return false;
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        BlockEntity tileentity = worldserver.getBlockEntity(blockposition);
        if (tileentity instanceof ChestBlockEntity) {
            ((ChestBlockEntity)tileentity).recheckOpen();
        }
    }

    public SoundEvent getOpenChestSound() {
        return this.openSound;
    }

    public SoundEvent getCloseChestSound() {
        return this.closeSound;
    }

    public static class DoubleInventory
    implements MenuProvider {
        private final ChestBlockEntity tileentitychest;
        private final ChestBlockEntity tileentitychest1;
        public final CompoundContainer inventorylargechest;

        public DoubleInventory(ChestBlockEntity tileentitychest, ChestBlockEntity tileentitychest1, CompoundContainer inventorylargechest) {
            this.tileentitychest = tileentitychest;
            this.tileentitychest1 = tileentitychest1;
            this.inventorylargechest = inventorylargechest;
        }

        @Override
        public @Nullable AbstractContainerMenu createMenu(int i, Inventory playerinventory, Player entityhuman) {
            if (this.tileentitychest.canOpen(entityhuman) && this.tileentitychest1.canOpen(entityhuman)) {
                this.tileentitychest.unpackLootTable(playerinventory.player);
                this.tileentitychest1.unpackLootTable(playerinventory.player);
                return ChestMenu.sixRows(i, playerinventory, this.inventorylargechest);
            }
            Direction enumdirection = ChestBlock.getConnectedDirection(this.tileentitychest.getBlockState());
            Vec3 vec3d = this.tileentitychest.getBlockPos().getCenter();
            Vec3 vec3d1 = vec3d.add((double)enumdirection.getStepX() / 2.0, 0.0, (double)enumdirection.getStepZ() / 2.0);
            BaseContainerBlockEntity.sendChestLockedNotifications(vec3d1, entityhuman, this.getDisplayName());
            return null;
        }

        @Override
        public Component getDisplayName() {
            return this.tileentitychest.hasCustomName() ? this.tileentitychest.getDisplayName() : (this.tileentitychest1.hasCustomName() ? this.tileentitychest1.getDisplayName() : Component.translatable("container.chestDouble"));
        }
    }
}

