/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class CommandBlock
extends BaseEntityBlock
implements GameMasterBlock {
    public static final MapCodec<CommandBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("automatic").forGetter(blockcommand -> blockcommand.automatic), CommandBlock.propertiesCodec()).apply((Applicative)instance, CommandBlock::new));
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final EnumProperty<Direction> FACING = DirectionalBlock.FACING;
    public static final BooleanProperty CONDITIONAL = BlockStateProperties.CONDITIONAL;
    private final boolean automatic;

    public MapCodec<CommandBlock> codec() {
        return CODEC;
    }

    public CommandBlock(boolean flag, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(CONDITIONAL, false));
        this.automatic = flag;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        CommandBlockEntity tileentitycommand = new CommandBlockEntity(blockposition, iblockdata);
        tileentitycommand.setAutomatic(this.automatic);
        return tileentitycommand;
    }

    @Override
    protected void neighborChanged(BlockState iblockdata, Level world, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        BlockEntity tileentity;
        if (!world.isClientSide() && (tileentity = world.getBlockEntity(blockposition)) instanceof CommandBlockEntity) {
            CommandBlockEntity tileentitycommand = (CommandBlockEntity)tileentity;
            this.setPoweredAndUpdate(world, blockposition, tileentitycommand, world.hasNeighborSignal(blockposition));
        }
    }

    private void setPoweredAndUpdate(Level world, BlockPos blockposition, CommandBlockEntity tileentitycommand, boolean flag) {
        boolean flag1 = tileentitycommand.isPowered();
        org.bukkit.block.Block bukkitBlock = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
        int old = flag1 ? 15 : 0;
        int current = flag ? 15 : 0;
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(bukkitBlock, old, current);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        boolean bl = flag = eventRedstone.getNewCurrent() > 0;
        if (flag != flag1) {
            tileentitycommand.setPowered(flag);
            if (flag) {
                if (tileentitycommand.isAutomatic() || tileentitycommand.getMode() == CommandBlockEntity.Mode.SEQUENCE) {
                    return;
                }
                tileentitycommand.markConditionMet();
                world.scheduleTick(blockposition, this, 1);
            }
        }
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        BlockEntity tileentity = worldserver.getBlockEntity(blockposition);
        if (tileentity instanceof CommandBlockEntity) {
            CommandBlockEntity tileentitycommand = (CommandBlockEntity)tileentity;
            BaseCommandBlock commandblocklistenerabstract = tileentitycommand.getCommandBlock();
            boolean flag = !StringUtil.isNullOrEmpty(commandblocklistenerabstract.getCommand());
            CommandBlockEntity.Mode tileentitycommand_type = tileentitycommand.getMode();
            boolean flag1 = tileentitycommand.wasConditionMet();
            if (tileentitycommand_type == CommandBlockEntity.Mode.AUTO) {
                tileentitycommand.markConditionMet();
                if (flag1) {
                    this.execute(iblockdata, worldserver, blockposition, commandblocklistenerabstract, flag);
                } else if (tileentitycommand.isConditional()) {
                    commandblocklistenerabstract.setSuccessCount(0);
                }
                if (tileentitycommand.isPowered() || tileentitycommand.isAutomatic()) {
                    worldserver.scheduleTick(blockposition, this, 1);
                }
            } else if (tileentitycommand_type == CommandBlockEntity.Mode.REDSTONE) {
                if (flag1) {
                    this.execute(iblockdata, worldserver, blockposition, commandblocklistenerabstract, flag);
                } else if (tileentitycommand.isConditional()) {
                    commandblocklistenerabstract.setSuccessCount(0);
                }
            }
            worldserver.updateNeighbourForOutputSignal(blockposition, this);
        }
    }

    private void execute(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, BaseCommandBlock commandblocklistenerabstract, boolean flag) {
        if (flag) {
            commandblocklistenerabstract.performCommand(worldserver);
        } else {
            commandblocklistenerabstract.setSuccessCount(0);
        }
        CommandBlock.executeChain(worldserver, blockposition, iblockdata.getValue(FACING));
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof CommandBlockEntity && entityhuman.canUseGameMasterBlocks()) {
            entityhuman.openCommandBlock((CommandBlockEntity)tileentity);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState iblockdata) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState iblockdata, Level world, BlockPos blockposition, Direction enumdirection) {
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        return tileentity instanceof CommandBlockEntity ? ((CommandBlockEntity)tileentity).getCommandBlock().getSuccessCount() : 0;
    }

    @Override
    public void setPlacedBy(Level world, BlockPos blockposition, BlockState iblockdata, @Nullable LivingEntity entityliving, ItemStack itemstack) {
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof CommandBlockEntity) {
            CommandBlockEntity tileentitycommand = (CommandBlockEntity)tileentity;
            BaseCommandBlock commandblocklistenerabstract = tileentitycommand.getCommandBlock();
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                if (!itemstack.has(DataComponents.BLOCK_ENTITY_DATA)) {
                    commandblocklistenerabstract.setTrackOutput(worldserver.getGameRules().get(GameRules.SEND_COMMAND_FEEDBACK));
                    tileentitycommand.setAutomatic(this.automatic);
                }
                boolean flag = world.hasNeighborSignal(blockposition);
                this.setPoweredAndUpdate(world, blockposition, tileentitycommand, flag);
            }
        }
    }

    @Override
    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        return (BlockState)iblockdata.setValue(FACING, enumblockrotation.rotate(iblockdata.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation(iblockdata.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(FACING, CONDITIONAL);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        return (BlockState)this.defaultBlockState().setValue(FACING, blockactioncontext.getNearestLookingDirection().getOpposite());
    }

    private static void executeChain(ServerLevel worldserver, BlockPos blockposition, Direction enumdirection) {
        BlockPos.MutableBlockPos blockposition_mutableblockposition = blockposition.mutable();
        GameRules gamerules = worldserver.getGameRules();
        int i = gamerules.get(GameRules.MAX_COMMAND_SEQUENCE_LENGTH);
        while (i-- > 0) {
            CommandBlockEntity tileentitycommand;
            BlockEntity tileentity;
            blockposition_mutableblockposition.move(enumdirection);
            BlockState iblockdata = worldserver.getBlockState(blockposition_mutableblockposition);
            Block block = iblockdata.getBlock();
            if (!iblockdata.is(Blocks.CHAIN_COMMAND_BLOCK) || !((tileentity = worldserver.getBlockEntity(blockposition_mutableblockposition)) instanceof CommandBlockEntity) || (tileentitycommand = (CommandBlockEntity)tileentity).getMode() != CommandBlockEntity.Mode.SEQUENCE) break;
            if (tileentitycommand.isPowered() || tileentitycommand.isAutomatic()) {
                BaseCommandBlock commandblocklistenerabstract = tileentitycommand.getCommandBlock();
                if (tileentitycommand.markConditionMet()) {
                    if (!commandblocklistenerabstract.performCommand(worldserver)) break;
                    worldserver.updateNeighbourForOutputSignal(blockposition_mutableblockposition, block);
                } else if (tileentitycommand.isConditional()) {
                    commandblocklistenerabstract.setSuccessCount(0);
                }
            }
            enumdirection = iblockdata.getValue(FACING);
        }
        if (i <= 0) {
            int j = Math.max(gamerules.get(GameRules.MAX_COMMAND_SEQUENCE_LENGTH), 0);
            LOGGER.warn("Command Block chain tried to execute more than {} steps!", (Object)j);
        }
    }
}

