/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;

public class CoralWallFanBlock
extends BaseCoralWallFanBlock {
    public static final MapCodec<CoralWallFanBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CoralBlock.DEAD_CORAL_FIELD.forGetter(blockcoralfanwall -> blockcoralfanwall.deadBlock), CoralWallFanBlock.propertiesCodec()).apply((Applicative)instance, CoralWallFanBlock::new));
    private final Block deadBlock;

    public MapCodec<CoralWallFanBlock> codec() {
        return CODEC;
    }

    protected CoralWallFanBlock(Block block, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.deadBlock = block;
    }

    @Override
    protected void onPlace(BlockState iblockdata, Level world, BlockPos blockposition, BlockState iblockdata1, boolean flag) {
        this.tryScheduleDieTick(iblockdata, world, world, world.random, blockposition);
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (!CoralWallFanBlock.scanForWater(iblockdata, worldserver, blockposition)) {
            if (CraftEventFactory.callBlockFadeEvent(worldserver, blockposition, (BlockState)((BlockState)this.deadBlock.defaultBlockState().setValue(WATERLOGGED, false)).setValue(FACING, (Direction)iblockdata.getValue(FACING))).isCancelled()) {
                return;
            }
            worldserver.setBlock(blockposition, (BlockState)((BlockState)this.deadBlock.defaultBlockState().setValue(WATERLOGGED, false)).setValue(FACING, (Direction)iblockdata.getValue(FACING)), 2);
        }
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (enumdirection.getOpposite() == iblockdata.getValue(FACING) && !iblockdata.canSurvive(iworldreader, blockposition)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            scheduledtickaccess.scheduleTick(blockposition, Fluids.WATER, Fluids.WATER.getTickDelay(iworldreader));
        }
        this.tryScheduleDieTick(iblockdata, iworldreader, scheduledtickaccess, randomsource, blockposition);
        return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }
}

