/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeCache;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftInventoryDoubleChest;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.Nullable;

public class CrafterBlock
extends BaseEntityBlock {
    public static final MapCodec<CrafterBlock> CODEC = CrafterBlock.simpleCodec(CrafterBlock::new);
    public static final BooleanProperty CRAFTING = BlockStateProperties.CRAFTING;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    private static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.ORIENTATION;
    private static final int MAX_CRAFTING_TICKS = 6;
    private static final int CRAFTING_TICK_DELAY = 4;
    private static final RecipeCache RECIPE_CACHE = new RecipeCache(10);
    private static final int CRAFTER_ADVANCEMENT_DIAMETER = 17;

    public CrafterBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(ORIENTATION, FrontAndTop.NORTH_UP)).setValue(TRIGGERED, false)).setValue(CRAFTING, false));
    }

    protected MapCodec<CrafterBlock> codec() {
        return CODEC;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState iblockdata) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState iblockdata, Level world, BlockPos blockposition, Direction enumdirection) {
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)tileentity;
            return crafterblockentity.getRedstoneSignal();
        }
        return 0;
    }

    @Override
    protected void neighborChanged(BlockState iblockdata, Level world, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        boolean flag1 = world.hasNeighborSignal(blockposition);
        boolean flag2 = iblockdata.getValue(TRIGGERED);
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (flag1 && !flag2) {
            world.scheduleTick(blockposition, this, 4);
            world.setBlock(blockposition, (BlockState)iblockdata.setValue(TRIGGERED, true), 2);
            this.setBlockEntityTriggered(tileentity, true);
        } else if (!flag1 && flag2) {
            world.setBlock(blockposition, (BlockState)((BlockState)iblockdata.setValue(TRIGGERED, false)).setValue(CRAFTING, false), 2);
            this.setBlockEntityTriggered(tileentity, false);
        }
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        this.dispenseFrom(iblockdata, worldserver, blockposition);
    }

    @Override
    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> getTicker(Level world, BlockState iblockdata, BlockEntityType<T> tileentitytypes) {
        return world.isClientSide() ? null : CrafterBlock.createTickerHelper(tileentitytypes, BlockEntityType.CRAFTER, CrafterBlockEntity::serverTick);
    }

    private void setBlockEntityTriggered(@Nullable BlockEntity tileentity, boolean flag) {
        if (tileentity instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)tileentity;
            crafterblockentity.setTriggered(flag);
        }
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        CrafterBlockEntity crafterblockentity = new CrafterBlockEntity(blockposition, iblockdata);
        crafterblockentity.setTriggered(iblockdata.hasProperty(TRIGGERED) && iblockdata.getValue(TRIGGERED) != false);
        return crafterblockentity;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        Direction enumdirection = blockactioncontext.getNearestLookingDirection().getOpposite();
        Direction enumdirection2 = switch (enumdirection) {
            case Direction.DOWN -> blockactioncontext.getHorizontalDirection().getOpposite();
            case Direction.UP -> blockactioncontext.getHorizontalDirection();
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> Direction.UP;
            default -> throw new MatchException(null, null);
        };
        return (BlockState)((BlockState)this.defaultBlockState().setValue(ORIENTATION, FrontAndTop.fromFrontAndTop(enumdirection, enumdirection2))).setValue(TRIGGERED, blockactioncontext.getLevel().hasNeighborSignal(blockactioncontext.getClickedPos()));
    }

    @Override
    public void setPlacedBy(Level world, BlockPos blockposition, BlockState iblockdata, @Nullable LivingEntity entityliving, net.minecraft.world.item.ItemStack itemstack) {
        if (iblockdata.getValue(TRIGGERED).booleanValue()) {
            world.scheduleTick(blockposition, this, 4);
        }
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, boolean flag) {
        Containers.updateNeighboursAfterDestroy(iblockdata, worldserver, blockposition);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        BlockEntity tileentity;
        if (!world.isClientSide() && (tileentity = world.getBlockEntity(blockposition)) instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)tileentity;
            entityhuman.openMenu(crafterblockentity);
        }
        return InteractionResult.SUCCESS;
    }

    protected void dispenseFrom(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition) {
        BlockEntity tileentity = worldserver.getBlockEntity(blockposition);
        if (tileentity instanceof CrafterBlockEntity) {
            CrafterBlockEntity crafterblockentity = (CrafterBlockEntity)tileentity;
            CraftingInput craftinginput = crafterblockentity.asCraftInput();
            Optional<RecipeHolder<CraftingRecipe>> optional = CrafterBlock.getPotentialResults(worldserver, craftinginput);
            if (optional.isEmpty()) {
                worldserver.levelEvent(1050, blockposition, 0);
            } else {
                RecipeHolder<CraftingRecipe> recipeholder = optional.get();
                net.minecraft.world.item.ItemStack itemstack = recipeholder.value().assemble(craftinginput, worldserver.registryAccess());
                CrafterCraftEvent event = CraftEventFactory.callCrafterCraftEvent(blockposition, worldserver, crafterblockentity, itemstack, recipeholder.value().getRemainingItems(craftinginput), recipeholder);
                if (event.isCancelled()) {
                    return;
                }
                itemstack = CraftItemStack.asNMSCopy(event.getResult());
                if (itemstack.isEmpty()) {
                    worldserver.levelEvent(1050, blockposition, 0);
                } else {
                    crafterblockentity.setCraftingTicksRemaining(6);
                    worldserver.setBlock(blockposition, (BlockState)iblockdata.setValue(CRAFTING, true), 2);
                    itemstack.onCraftedBySystem(worldserver);
                    this.dispenseItem(worldserver, blockposition, crafterblockentity, itemstack, iblockdata, recipeholder);
                    for (net.minecraft.world.item.ItemStack itemstack1 : event.getRemainingItems().stream().map(CraftItemStack::asNMSCopy).toList()) {
                        if (itemstack1.isEmpty()) continue;
                        this.dispenseItem(worldserver, blockposition, crafterblockentity, itemstack1, iblockdata, recipeholder);
                    }
                    crafterblockentity.getItems().forEach(itemstack2 -> {
                        if (!itemstack2.isEmpty()) {
                            itemstack2.shrink(1);
                        }
                    });
                    crafterblockentity.setChanged();
                }
            }
        }
    }

    public static Optional<RecipeHolder<CraftingRecipe>> getPotentialResults(ServerLevel worldserver, CraftingInput craftinginput) {
        return RECIPE_CACHE.get(worldserver, craftinginput);
    }

    private void dispenseItem(ServerLevel worldserver, BlockPos blockposition, CrafterBlockEntity crafterblockentity, net.minecraft.world.item.ItemStack itemstack, BlockState iblockdata, RecipeHolder<?> recipeholder) {
        Direction enumdirection = iblockdata.getValue(ORIENTATION).front();
        Container iinventory = HopperBlockEntity.getContainerAt(worldserver, blockposition.relative(enumdirection));
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.copy();
        if (iinventory != null && (iinventory instanceof CrafterBlockEntity || itemstack.getCount() > iinventory.getMaxStackSize(itemstack))) {
            net.minecraft.world.item.ItemStack itemstack2;
            net.minecraft.world.item.ItemStack itemstack3;
            oitemstack = CraftItemStack.asCraftMirror(itemstack1);
            destinationInventory = iinventory instanceof CompoundContainer ? new CraftInventoryDoubleChest((CompoundContainer)iinventory) : iinventory.getOwner().getInventory();
            event = new InventoryMoveItemEvent(crafterblockentity.getOwner().getInventory(), (ItemStack)oitemstack, destinationInventory, true);
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
            itemstack1 = CraftItemStack.asNMSCopy(event.getItem());
            while (!itemstack1.isEmpty() && !event.isCancelled() && (itemstack3 = HopperBlockEntity.addItem(crafterblockentity, iinventory, itemstack2 = itemstack1.copyWithCount(1), enumdirection.getOpposite())).isEmpty()) {
                itemstack1.shrink(1);
            }
        } else if (iinventory != null) {
            int i;
            oitemstack = CraftItemStack.asCraftMirror(itemstack1);
            destinationInventory = iinventory instanceof CompoundContainer ? new CraftInventoryDoubleChest((CompoundContainer)iinventory) : iinventory.getOwner().getInventory();
            event = new InventoryMoveItemEvent(crafterblockentity.getOwner().getInventory(), (ItemStack)oitemstack, destinationInventory, true);
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
            itemstack1 = CraftItemStack.asNMSCopy(event.getItem());
            while (!itemstack1.isEmpty() && !event.isCancelled() && (i = itemstack1.getCount()) != (itemstack1 = HopperBlockEntity.addItem(crafterblockentity, iinventory, itemstack1, enumdirection.getOpposite())).getCount()) {
            }
        }
        if (!itemstack1.isEmpty()) {
            Vec3 vec3d = Vec3.atCenterOf(blockposition);
            Vec3 vec3d1 = vec3d.relative(enumdirection, 0.7);
            DefaultDispenseItemBehavior.spawnItem(worldserver, itemstack1, 6, enumdirection, vec3d1);
            for (ServerPlayer entityplayer : worldserver.getEntitiesOfClass(ServerPlayer.class, AABB.ofSize(vec3d, 17.0, 17.0, 17.0))) {
                CriteriaTriggers.CRAFTER_RECIPE_CRAFTED.trigger(entityplayer, recipeholder.id(), crafterblockentity.getItems());
            }
            worldserver.levelEvent(1049, blockposition, 0);
            worldserver.levelEvent(2010, blockposition, enumdirection.get3DDataValue());
        }
    }

    @Override
    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        return (BlockState)iblockdata.setValue(ORIENTATION, enumblockrotation.rotation().rotate(iblockdata.getValue(ORIENTATION)));
    }

    @Override
    protected BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        return (BlockState)iblockdata.setValue(ORIENTATION, enumblockmirror.rotation().rotate(iblockdata.getValue(ORIENTATION)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(ORIENTATION, TRIGGERED, CRAFTING);
    }
}

