/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.jspecify.annotations.Nullable;

public abstract class DiodeBlock
extends HorizontalDirectionalBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final VoxelShape SHAPE = Block.column(16.0, 0.0, 2.0);

    protected DiodeBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
    }

    protected abstract MapCodec<? extends DiodeBlock> codec();

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPE;
    }

    @Override
    protected boolean canSurvive(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        BlockPos blockposition1 = blockposition.below();
        return this.canSurviveOn(iworldreader, blockposition1, iworldreader.getBlockState(blockposition1));
    }

    protected boolean canSurviveOn(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata) {
        return iblockdata.isFaceSturdy(iworldreader, blockposition, Direction.UP, SupportType.RIGID);
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (!this.isLocked(worldserver, blockposition, iblockdata)) {
            boolean flag = iblockdata.getValue(POWERED);
            boolean flag1 = this.shouldTurnOn(worldserver, blockposition, iblockdata);
            if (flag && !flag1) {
                if (CraftEventFactory.callRedstoneChange(worldserver, blockposition, 15, 0).getNewCurrent() != 0) {
                    return;
                }
                worldserver.setBlock(blockposition, (BlockState)iblockdata.setValue(POWERED, false), 2);
            } else if (!flag) {
                if (CraftEventFactory.callRedstoneChange(worldserver, blockposition, 0, 15).getNewCurrent() != 15) {
                    return;
                }
                worldserver.setBlock(blockposition, (BlockState)iblockdata.setValue(POWERED, true), 2);
                if (!flag1) {
                    worldserver.scheduleTick(blockposition, this, this.getDelay(iblockdata), TickPriority.VERY_HIGH);
                }
            }
        }
    }

    @Override
    protected int getDirectSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return iblockdata.getSignal(iblockaccess, blockposition, enumdirection);
    }

    @Override
    protected int getSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return iblockdata.getValue(POWERED) == false ? 0 : (iblockdata.getValue(FACING) == enumdirection ? this.getOutputSignal(iblockaccess, blockposition, iblockdata) : 0);
    }

    @Override
    protected void neighborChanged(BlockState iblockdata, Level world, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        if (iblockdata.canSurvive(world, blockposition)) {
            this.checkTickOnNeighbor(world, blockposition, iblockdata);
        } else {
            BlockEntity tileentity = iblockdata.hasBlockEntity() ? world.getBlockEntity(blockposition) : null;
            DiodeBlock.dropResources(iblockdata, world, blockposition, tileentity);
            world.removeBlock(blockposition, false);
            for (Direction enumdirection : Direction.values()) {
                world.updateNeighborsAt(blockposition.relative(enumdirection), this);
            }
        }
    }

    protected void checkTickOnNeighbor(Level world, BlockPos blockposition, BlockState iblockdata) {
        boolean flag1;
        boolean flag;
        if (!this.isLocked(world, blockposition, iblockdata) && (flag = iblockdata.getValue(POWERED).booleanValue()) != (flag1 = this.shouldTurnOn(world, blockposition, iblockdata)) && !world.getBlockTicks().willTickThisTick(blockposition, this)) {
            TickPriority ticklistpriority = TickPriority.HIGH;
            if (this.shouldPrioritize(world, blockposition, iblockdata)) {
                ticklistpriority = TickPriority.EXTREMELY_HIGH;
            } else if (flag) {
                ticklistpriority = TickPriority.VERY_HIGH;
            }
            world.scheduleTick(blockposition, this, this.getDelay(iblockdata), ticklistpriority);
        }
    }

    public boolean isLocked(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata) {
        return false;
    }

    protected boolean shouldTurnOn(Level world, BlockPos blockposition, BlockState iblockdata) {
        return this.getInputSignal(world, blockposition, iblockdata) > 0;
    }

    protected int getInputSignal(Level world, BlockPos blockposition, BlockState iblockdata) {
        Direction enumdirection = (Direction)iblockdata.getValue(FACING);
        BlockPos blockposition1 = blockposition.relative(enumdirection);
        int i = world.getSignal(blockposition1, enumdirection);
        if (i >= 15) {
            return i;
        }
        BlockState iblockdata1 = world.getBlockState(blockposition1);
        return Math.max(i, iblockdata1.is(Blocks.REDSTONE_WIRE) ? iblockdata1.getValue(RedStoneWireBlock.POWER) : 0);
    }

    protected int getAlternateSignal(SignalGetter signalgetter, BlockPos blockposition, BlockState iblockdata) {
        Direction enumdirection = (Direction)iblockdata.getValue(FACING);
        Direction enumdirection1 = enumdirection.getClockWise();
        Direction enumdirection2 = enumdirection.getCounterClockWise();
        boolean flag = this.sideInputDiodesOnly();
        return Math.max(signalgetter.getControlInputSignal(blockposition.relative(enumdirection1), enumdirection1, flag), signalgetter.getControlInputSignal(blockposition.relative(enumdirection2), enumdirection2, flag));
    }

    @Override
    protected boolean isSignalSource(BlockState iblockdata) {
        return true;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        return (BlockState)this.defaultBlockState().setValue(FACING, blockactioncontext.getHorizontalDirection().getOpposite());
    }

    @Override
    public void setPlacedBy(Level world, BlockPos blockposition, BlockState iblockdata, @Nullable LivingEntity entityliving, ItemStack itemstack) {
        if (this.shouldTurnOn(world, blockposition, iblockdata)) {
            world.scheduleTick(blockposition, this, 1);
        }
    }

    @Override
    protected void onPlace(BlockState iblockdata, Level world, BlockPos blockposition, BlockState iblockdata1, boolean flag) {
        this.updateNeighborsInFront(world, blockposition, iblockdata);
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, boolean flag) {
        if (!flag) {
            this.updateNeighborsInFront(worldserver, blockposition, iblockdata);
        }
    }

    protected void updateNeighborsInFront(Level world, BlockPos blockposition, BlockState iblockdata) {
        Direction enumdirection = (Direction)iblockdata.getValue(FACING);
        BlockPos blockposition1 = blockposition.relative(enumdirection.getOpposite());
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation(world, enumdirection.getOpposite(), Direction.UP);
        world.neighborChanged(blockposition1, this, orientation);
        world.updateNeighborsAtExceptFromFacing(blockposition1, this, enumdirection, orientation);
    }

    protected boolean sideInputDiodesOnly() {
        return false;
    }

    protected int getOutputSignal(BlockGetter iblockaccess, BlockPos blockposition, BlockState iblockdata) {
        return 15;
    }

    public static boolean isDiode(BlockState iblockdata) {
        return iblockdata.getBlock() instanceof DiodeBlock;
    }

    public boolean shouldPrioritize(BlockGetter iblockaccess, BlockPos blockposition, BlockState iblockdata) {
        Direction enumdirection = ((Direction)iblockdata.getValue(FACING)).getOpposite();
        BlockState iblockdata1 = iblockaccess.getBlockState(blockposition.relative(enumdirection));
        return DiodeBlock.isDiode(iblockdata1) && iblockdata1.getValue(FACING) != enumdirection;
    }

    protected abstract int getDelay(BlockState var1);
}

