/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.Fluids;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.jspecify.annotations.Nullable;

public class DoublePlantBlock
extends VegetationBlock {
    public static final MapCodec<DoublePlantBlock> CODEC = DoublePlantBlock.simpleCodec(DoublePlantBlock::new);
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;

    public MapCodec<? extends DoublePlantBlock> codec() {
        return CODEC;
    }

    public DoublePlantBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, DoubleBlockHalf.LOWER));
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        DoubleBlockHalf blockpropertydoubleblockhalf = iblockdata.getValue(HALF);
        return enumdirection.getAxis() != Direction.Axis.Y || blockpropertydoubleblockhalf == DoubleBlockHalf.LOWER != (enumdirection == Direction.UP) || iblockdata1.is(this) && iblockdata1.getValue(HALF) != blockpropertydoubleblockhalf ? (blockpropertydoubleblockhalf == DoubleBlockHalf.LOWER && enumdirection == Direction.DOWN && !iblockdata.canSurvive(iworldreader, blockposition) ? Blocks.AIR.defaultBlockState() : super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource)) : Blocks.AIR.defaultBlockState();
    }

    @Override
    public @Nullable BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        BlockPos blockposition = blockactioncontext.getClickedPos();
        Level world = blockactioncontext.getLevel();
        return blockposition.getY() < world.getMaxY() && world.getBlockState(blockposition.above()).canBeReplaced(blockactioncontext) ? super.getStateForPlacement(blockactioncontext) : null;
    }

    @Override
    public void setPlacedBy(Level world, BlockPos blockposition, BlockState iblockdata, @Nullable LivingEntity entityliving, ItemStack itemstack) {
        BlockPos blockposition1 = blockposition.above();
        world.setBlock(blockposition1, DoublePlantBlock.copyWaterloggedFrom(world, blockposition1, (BlockState)this.defaultBlockState().setValue(HALF, DoubleBlockHalf.UPPER)), 3);
    }

    @Override
    protected boolean canSurvive(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        if (iblockdata.getValue(HALF) != DoubleBlockHalf.UPPER) {
            return super.canSurvive(iblockdata, iworldreader, blockposition);
        }
        BlockState iblockdata1 = iworldreader.getBlockState(blockposition.below());
        return iblockdata1.is(this) && iblockdata1.getValue(HALF) == DoubleBlockHalf.LOWER;
    }

    public static void placeAt(LevelAccessor generatoraccess, BlockState iblockdata, BlockPos blockposition, @Block.UpdateFlags int i) {
        BlockPos blockposition1 = blockposition.above();
        generatoraccess.setBlock(blockposition, DoublePlantBlock.copyWaterloggedFrom(generatoraccess, blockposition, (BlockState)iblockdata.setValue(HALF, DoubleBlockHalf.LOWER)), i);
        generatoraccess.setBlock(blockposition1, DoublePlantBlock.copyWaterloggedFrom(generatoraccess, blockposition1, (BlockState)iblockdata.setValue(HALF, DoubleBlockHalf.UPPER)), i);
    }

    public static BlockState copyWaterloggedFrom(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata) {
        return iblockdata.hasProperty(BlockStateProperties.WATERLOGGED) ? (BlockState)iblockdata.setValue(BlockStateProperties.WATERLOGGED, iworldreader.isWaterAt(blockposition)) : iblockdata;
    }

    @Override
    public BlockState playerWillDestroy(Level world, BlockPos blockposition, BlockState iblockdata, Player entityhuman) {
        if (!world.isClientSide()) {
            if (entityhuman.preventsBlockDrops()) {
                DoublePlantBlock.preventDropFromBottomPart(world, blockposition, iblockdata, entityhuman);
            } else {
                DoublePlantBlock.dropResources(iblockdata, world, blockposition, null, entityhuman, entityhuman.getMainHandItem());
            }
        }
        return super.playerWillDestroy(world, blockposition, iblockdata, entityhuman);
    }

    @Override
    public void playerDestroy(Level world, Player entityhuman, BlockPos blockposition, BlockState iblockdata, @Nullable BlockEntity tileentity, ItemStack itemstack) {
        super.playerDestroy(world, entityhuman, blockposition, Blocks.AIR.defaultBlockState(), tileentity, itemstack);
    }

    protected static void preventDropFromBottomPart(Level world, BlockPos blockposition, BlockState iblockdata, Player entityhuman) {
        BlockPos blockposition1;
        BlockState iblockdata1;
        if (CraftEventFactory.callBlockPhysicsEvent(world, blockposition).isCancelled()) {
            return;
        }
        DoubleBlockHalf blockpropertydoubleblockhalf = iblockdata.getValue(HALF);
        if (blockpropertydoubleblockhalf == DoubleBlockHalf.UPPER && (iblockdata1 = world.getBlockState(blockposition1 = blockposition.below())).is(iblockdata.getBlock()) && iblockdata1.getValue(HALF) == DoubleBlockHalf.LOWER) {
            BlockState iblockdata2 = iblockdata1.getFluidState().is(Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            world.setBlock(blockposition1, iblockdata2, 35);
            world.levelEvent(entityhuman, 2001, blockposition1, Block.getId(iblockdata1));
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(HALF);
    }

    @Override
    protected long getSeed(BlockState iblockdata, BlockPos blockposition) {
        return Mth.getSeed(blockposition.getX(), blockposition.below(iblockdata.getValue(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).getY(), blockposition.getZ());
    }
}

