/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.EnchantingTableBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class EnchantingTableBlock
extends BaseEntityBlock {
    public static final MapCodec<EnchantingTableBlock> CODEC = EnchantingTableBlock.simpleCodec(EnchantingTableBlock::new);
    public static final List<BlockPos> BOOKSHELF_OFFSETS = BlockPos.betweenClosedStream(-2, 0, -2, 2, 1, 2).filter(var0 -> Math.abs(var0.getX()) == 2 || Math.abs(var0.getZ()) == 2).map(BlockPos::immutable).toList();
    private static final VoxelShape SHAPE = Block.column(16.0, 0.0, 12.0);

    public MapCodec<EnchantingTableBlock> codec() {
        return CODEC;
    }

    protected EnchantingTableBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    public static boolean isValidBookShelf(Level var0, BlockPos var1, BlockPos var2) {
        return var0.getBlockState(var1.offset(var2)).is(BlockTags.ENCHANTMENT_POWER_PROVIDER) && var0.getBlockState(var1.offset(var2.getX() / 2, var2.getY(), var2.getZ() / 2)).is(BlockTags.ENCHANTMENT_POWER_TRANSMITTER);
    }

    @Override
    protected boolean useShapeForLightOcclusion(BlockState var0) {
        return true;
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return SHAPE;
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        super.animateTick(var0, var1, var2, var3);
        for (BlockPos var5 : BOOKSHELF_OFFSETS) {
            if (var3.nextInt(16) != 0 || !EnchantingTableBlock.isValidBookShelf(var1, var2, var5)) continue;
            var1.addParticle(ParticleTypes.ENCHANT, (double)var2.getX() + 0.5, (double)var2.getY() + 2.0, (double)var2.getZ() + 0.5, (double)((float)var5.getX() + var3.nextFloat()) - 0.5, (float)var5.getY() - var3.nextFloat() - 1.0f, (double)((float)var5.getZ() + var3.nextFloat()) - 0.5);
        }
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return new EnchantingTableBlockEntity(var0, var1);
    }

    @Override
    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> getTicker(Level var0, BlockState var1, BlockEntityType<T> var2) {
        return var0.isClientSide() ? EnchantingTableBlock.createTickerHelper(var2, BlockEntityType.ENCHANTING_TABLE, EnchantingTableBlockEntity::bookAnimationTick) : null;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState var0, Level var1, BlockPos var2, Player var3, BlockHitResult var4) {
        if (!var1.isClientSide()) {
            var3.openMenu(var0.getMenuProvider(var1, var2));
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected @Nullable MenuProvider getMenuProvider(BlockState var0, Level var1, BlockPos var22) {
        BlockEntity var32 = var1.getBlockEntity(var22);
        if (var32 instanceof EnchantingTableBlockEntity) {
            EnchantingTableBlockEntity var42 = (EnchantingTableBlockEntity)var32;
            Component var5 = var42.getDisplayName();
            return new SimpleMenuProvider((var2, var3, var4) -> new EnchantmentMenu(var2, var3, ContainerLevelAccess.create(var1, var22)), var5);
        }
        return null;
    }

    @Override
    protected boolean isPathfindable(BlockState var0, PathComputationType var1) {
        return false;
    }
}

