/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import org.jspecify.annotations.Nullable;

public abstract class FaceAttachedHorizontalDirectionalBlock
extends HorizontalDirectionalBlock {
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.ATTACH_FACE;

    protected FaceAttachedHorizontalDirectionalBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    protected abstract MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec();

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        return FaceAttachedHorizontalDirectionalBlock.canAttach(var1, var2, FaceAttachedHorizontalDirectionalBlock.getConnectedDirection(var0).getOpposite());
    }

    public static boolean canAttach(LevelReader var0, BlockPos var1, Direction var2) {
        BlockPos var3 = var1.relative(var2);
        return var0.getBlockState(var3).isFaceSturdy(var0, var3, var2.getOpposite());
    }

    @Override
    public @Nullable BlockState getStateForPlacement(BlockPlaceContext var0) {
        for (Direction var4 : var0.getNearestLookingDirections()) {
            BlockState var5 = var4.getAxis() == Direction.Axis.Y ? (BlockState)((BlockState)this.defaultBlockState().setValue(FACE, var4 == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR)).setValue(FACING, var0.getHorizontalDirection()) : (BlockState)((BlockState)this.defaultBlockState().setValue(FACE, AttachFace.WALL)).setValue(FACING, var4.getOpposite());
            if (!var5.canSurvive(var0.getLevel(), var0.getClickedPos())) continue;
            return var5;
        }
        return null;
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (FaceAttachedHorizontalDirectionalBlock.getConnectedDirection(var0).getOpposite() == var4 && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    protected static Direction getConnectedDirection(BlockState var0) {
        switch (var0.getValue(FACE)) {
            case CEILING: {
                return Direction.DOWN;
            }
            case FLOOR: {
                return Direction.UP;
            }
        }
        return (Direction)var0.getValue(FACING);
    }
}

