/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;

public class FurnaceBlock
extends AbstractFurnaceBlock {
    public static final MapCodec<FurnaceBlock> CODEC = FurnaceBlock.simpleCodec(FurnaceBlock::new);

    public MapCodec<FurnaceBlock> codec() {
        return CODEC;
    }

    protected FurnaceBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return new FurnaceBlockEntity(var0, var1);
    }

    @Override
    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> getTicker(Level var0, BlockState var1, BlockEntityType<T> var2) {
        return FurnaceBlock.createFurnaceTicker(var0, var2, BlockEntityType.FURNACE);
    }

    @Override
    protected void openContainer(Level var0, BlockPos var1, Player var2) {
        BlockEntity var3 = var0.getBlockEntity(var1);
        if (var3 instanceof FurnaceBlockEntity) {
            var2.openMenu((MenuProvider)((Object)var3));
            var2.awardStat(Stats.INTERACT_WITH_FURNACE);
        }
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        if (!var0.getValue(LIT).booleanValue()) {
            return;
        }
        double var4 = (double)var2.getX() + 0.5;
        double var6 = var2.getY();
        double var8 = (double)var2.getZ() + 0.5;
        if (var3.nextDouble() < 0.1) {
            var1.playLocalSound(var4, var6, var8, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        Direction var10 = (Direction)var0.getValue(FACING);
        Direction.Axis var11 = var10.getAxis();
        double var12 = 0.52;
        double var14 = var3.nextDouble() * 0.6 - 0.3;
        double var16 = var11 == Direction.Axis.X ? (double)var10.getStepX() * 0.52 : var14;
        double var18 = var3.nextDouble() * 6.0 / 16.0;
        double var20 = var11 == Direction.Axis.Z ? (double)var10.getStepZ() * 0.52 : var14;
        var1.addParticle(ParticleTypes.SMOKE, var4 + var16, var6 + var18, var8 + var20, 0.0, 0.0, 0.0);
        var1.addParticle(ParticleTypes.FLAME, var4 + var16, var6 + var18, var8 + var20, 0.0, 0.0, 0.0);
    }
}

