/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.BlockUtil;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class GrowingPlantBodyBlock
extends GrowingPlantBlock
implements BonemealableBlock {
    protected GrowingPlantBodyBlock(BlockBehaviour.Properties var0, Direction var1, VoxelShape var2, boolean var3) {
        super(var0, var1, var2, var3);
    }

    protected abstract MapCodec<? extends GrowingPlantBodyBlock> codec();

    protected BlockState updateHeadAfterConvertedFromBody(BlockState var0, BlockState var1) {
        return var1;
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var4 == this.growthDirection.getOpposite() && !var0.canSurvive(var1, var3)) {
            var2.scheduleTick(var3, this, 1);
        }
        GrowingPlantHeadBlock var8 = this.getHeadBlock();
        if (var4 == this.growthDirection && !var6.is(this) && !var6.is(var8)) {
            return this.updateHeadAfterConvertedFromBody(var0, var8.getStateForPlacement(var7));
        }
        if (this.scheduleFluidTicks) {
            var2.scheduleTick(var3, Fluids.WATER, Fluids.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader var0, BlockPos var1, BlockState var2, boolean var3) {
        return new ItemStack(this.getHeadBlock());
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader var0, BlockPos var1, BlockState var2) {
        Optional<BlockPos> var3 = this.getHeadPos(var0, var1, var2.getBlock());
        return var3.isPresent() && this.getHeadBlock().canGrowInto(var0.getBlockState(var3.get().relative(this.growthDirection)));
    }

    @Override
    public boolean isBonemealSuccess(Level var0, RandomSource var1, BlockPos var2, BlockState var3) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel var0, RandomSource var1, BlockPos var2, BlockState var3) {
        Optional<BlockPos> var4 = this.getHeadPos(var0, var2, var3.getBlock());
        if (var4.isPresent()) {
            BlockState var5 = var0.getBlockState(var4.get());
            ((GrowingPlantHeadBlock)var5.getBlock()).performBonemeal(var0, var1, var4.get(), var5);
        }
    }

    private Optional<BlockPos> getHeadPos(BlockGetter var0, BlockPos var1, Block var2) {
        return BlockUtil.getTopConnectedBlock(var0, var1, var2, this.growthDirection, this.getHeadBlock());
    }

    @Override
    protected boolean canBeReplaced(BlockState var0, BlockPlaceContext var1) {
        boolean var2 = super.canBeReplaced(var0, var1);
        if (var2 && var1.getItemInHand().is(this.getHeadBlock().asItem())) {
            return false;
        }
        return var2;
    }

    @Override
    protected Block getBodyBlock() {
        return this;
    }
}

