/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class MultifaceBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final MapCodec<MultifaceBlock> CODEC = MultifaceBlock.simpleCodec(MultifaceBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = PipeBlock.PROPERTY_BY_DIRECTION;
    protected static final Direction[] DIRECTIONS = Direction.values();
    private final Function<BlockState, VoxelShape> shapes;
    private final boolean canRotate;
    private final boolean canMirrorX;
    private final boolean canMirrorZ;

    protected MapCodec<? extends MultifaceBlock> codec() {
        return CODEC;
    }

    public MultifaceBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState(MultifaceBlock.getDefaultMultifaceState(this.stateDefinition));
        this.shapes = this.makeShapes();
        this.canRotate = Direction.Plane.HORIZONTAL.stream().allMatch(this::isFaceSupported);
        this.canMirrorX = Direction.Plane.HORIZONTAL.stream().filter(Direction.Axis.X).filter(this::isFaceSupported).count() % 2L == 0L;
        this.canMirrorZ = Direction.Plane.HORIZONTAL.stream().filter(Direction.Axis.Z).filter(this::isFaceSupported).count() % 2L == 0L;
    }

    private Function<BlockState, VoxelShape> makeShapes() {
        Map<Direction, VoxelShape> var0 = Shapes.rotateAll(Block.boxZ(16.0, 0.0, 1.0));
        return this.getShapeForEachState(var1 -> {
            VoxelShape var2 = Shapes.empty();
            for (Direction var6 : DIRECTIONS) {
                if (!MultifaceBlock.hasFace(var1, var6)) continue;
                var2 = Shapes.or(var2, (VoxelShape)var0.get(var6));
            }
            return var2.isEmpty() ? Shapes.block() : var2;
        }, WATERLOGGED);
    }

    public static Set<Direction> availableFaces(BlockState var0) {
        if (!(var0.getBlock() instanceof MultifaceBlock)) {
            return Set.of();
        }
        EnumSet<Direction> var1 = EnumSet.noneOf(Direction.class);
        for (Direction var5 : Direction.values()) {
            if (!MultifaceBlock.hasFace(var0, var5)) continue;
            var1.add(var5);
        }
        return var1;
    }

    public static Set<Direction> unpack(byte var0) {
        EnumSet<Direction> var1 = EnumSet.noneOf(Direction.class);
        for (Direction var5 : Direction.values()) {
            if ((var0 & (byte)(1 << var5.ordinal())) <= 0) continue;
            var1.add(var5);
        }
        return var1;
    }

    public static byte pack(Collection<Direction> var0) {
        byte var1 = 0;
        for (Direction var3 : var0) {
            var1 = (byte)(var1 | 1 << var3.ordinal());
        }
        return var1;
    }

    protected boolean isFaceSupported(Direction var0) {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        for (Direction var4 : DIRECTIONS) {
            if (!this.isFaceSupported(var4)) continue;
            var0.add(MultifaceBlock.getFaceProperty(var4));
        }
        var0.add(WATERLOGGED);
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, Fluids.WATER, Fluids.WATER.getTickDelay(var1));
        }
        if (!MultifaceBlock.hasAnyFace(var0)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (!MultifaceBlock.hasFace(var0, var4) || MultifaceBlock.canAttachTo(var1, var4, var5, var6)) {
            return var0;
        }
        return MultifaceBlock.removeFace(var0, MultifaceBlock.getFaceProperty(var4));
    }

    @Override
    protected FluidState getFluidState(BlockState var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return this.shapes.apply(var0);
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        boolean var3 = false;
        for (Direction var7 : DIRECTIONS) {
            if (!MultifaceBlock.hasFace(var0, var7)) continue;
            if (!MultifaceBlock.canAttachTo(var1, var2, var7)) {
                return false;
            }
            var3 = true;
        }
        return var3;
    }

    @Override
    protected boolean canBeReplaced(BlockState var0, BlockPlaceContext var1) {
        return !var1.getItemInHand().is(this.asItem()) || MultifaceBlock.hasAnyVacantFace(var0);
    }

    @Override
    public @Nullable BlockState getStateForPlacement(BlockPlaceContext var0) {
        Level var1 = var0.getLevel();
        BlockPos var2 = var0.getClickedPos();
        BlockState var32 = var1.getBlockState(var2);
        return Arrays.stream(var0.getNearestLookingDirections()).map(var3 -> this.getStateForPlacement(var32, var1, var2, (Direction)var3)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean isValidStateForPlacement(BlockGetter var0, BlockState var1, BlockPos var2, Direction var3) {
        if (!this.isFaceSupported(var3) || var1.is(this) && MultifaceBlock.hasFace(var1, var3)) {
            return false;
        }
        BlockPos var4 = var2.relative(var3);
        return MultifaceBlock.canAttachTo(var0, var3, var4, var0.getBlockState(var4));
    }

    public @Nullable BlockState getStateForPlacement(BlockState var0, BlockGetter var1, BlockPos var2, Direction var3) {
        if (!this.isValidStateForPlacement(var1, var0, var2, var3)) {
            return null;
        }
        BlockState var4 = var0.is(this) ? var0 : (var0.getFluidState().isSourceOfType(Fluids.WATER) ? (BlockState)this.defaultBlockState().setValue(BlockStateProperties.WATERLOGGED, true) : this.defaultBlockState());
        return (BlockState)var4.setValue(MultifaceBlock.getFaceProperty(var3), true);
    }

    @Override
    protected BlockState rotate(BlockState var0, Rotation var1) {
        if (!this.canRotate) {
            return var0;
        }
        return this.mapDirections(var0, var1::rotate);
    }

    @Override
    protected BlockState mirror(BlockState var0, Mirror var1) {
        if (var1 == Mirror.FRONT_BACK && !this.canMirrorX) {
            return var0;
        }
        if (var1 == Mirror.LEFT_RIGHT && !this.canMirrorZ) {
            return var0;
        }
        return this.mapDirections(var0, var1::mirror);
    }

    private BlockState mapDirections(BlockState var0, Function<Direction, Direction> var1) {
        BlockState var2 = var0;
        for (Direction var6 : DIRECTIONS) {
            if (!this.isFaceSupported(var6)) continue;
            var2 = (BlockState)var2.setValue(MultifaceBlock.getFaceProperty(var1.apply(var6)), var0.getValue(MultifaceBlock.getFaceProperty(var6)));
        }
        return var2;
    }

    public static boolean hasFace(BlockState var0, Direction var1) {
        BooleanProperty var2 = MultifaceBlock.getFaceProperty(var1);
        return var0.getValueOrElse(var2, false);
    }

    public static boolean canAttachTo(BlockGetter var0, BlockPos var1, Direction var2) {
        BlockPos var3 = var1.relative(var2);
        BlockState var4 = var0.getBlockState(var3);
        return MultifaceBlock.canAttachTo(var0, var2, var3, var4);
    }

    public static boolean canAttachTo(BlockGetter var0, Direction var1, BlockPos var2, BlockState var3) {
        return Block.isFaceFull(var3.getBlockSupportShape(var0, var2), var1.getOpposite()) || Block.isFaceFull(var3.getCollisionShape(var0, var2), var1.getOpposite());
    }

    private static BlockState removeFace(BlockState var0, BooleanProperty var1) {
        BlockState var2 = (BlockState)var0.setValue(var1, false);
        if (MultifaceBlock.hasAnyFace(var2)) {
            return var2;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public static BooleanProperty getFaceProperty(Direction var0) {
        return PROPERTY_BY_DIRECTION.get(var0);
    }

    private static BlockState getDefaultMultifaceState(StateDefinition<Block, BlockState> var0) {
        BlockState var1 = (BlockState)var0.any().setValue(WATERLOGGED, false);
        for (BooleanProperty var3 : PROPERTY_BY_DIRECTION.values()) {
            var1 = (BlockState)var1.trySetValue(var3, false);
        }
        return var1;
    }

    protected static boolean hasAnyFace(BlockState var0) {
        for (Direction var4 : DIRECTIONS) {
            if (!MultifaceBlock.hasFace(var0, var4)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnyVacantFace(BlockState var0) {
        for (Direction var4 : DIRECTIONS) {
            if (MultifaceBlock.hasFace(var0, var4)) continue;
            return true;
        }
        return false;
    }
}

