/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.lighting.LightEngine;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;

public class NyliumBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<NyliumBlock> CODEC = NyliumBlock.simpleCodec(NyliumBlock::new);

    public MapCodec<NyliumBlock> codec() {
        return CODEC;
    }

    protected NyliumBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
    }

    private static boolean canBeNylium(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        BlockPos blockposition1 = blockposition.above();
        BlockState iblockdata1 = iworldreader.getBlockState(blockposition1);
        int i = LightEngine.getLightBlockInto(iblockdata, iblockdata1, Direction.UP, iblockdata1.getLightBlock());
        return i < 15;
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (!NyliumBlock.canBeNylium(iblockdata, worldserver, blockposition)) {
            if (CraftEventFactory.callBlockFadeEvent(worldserver, blockposition, Blocks.NETHERRACK.defaultBlockState()).isCancelled()) {
                return;
            }
            worldserver.setBlockAndUpdate(blockposition, Blocks.NETHERRACK.defaultBlockState());
        }
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata) {
        return iworldreader.getBlockState(blockposition.above()).isAir();
    }

    @Override
    public boolean isBonemealSuccess(Level world, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel worldserver, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        BlockState iblockdata1 = worldserver.getBlockState(blockposition);
        BlockPos blockposition1 = blockposition.above();
        ChunkGenerator chunkgenerator = worldserver.getChunkSource().getGenerator();
        HolderLookup.RegistryLookup iregistry = worldserver.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE);
        if (iblockdata1.is(Blocks.CRIMSON_NYLIUM)) {
            this.place((Registry<ConfiguredFeature<?, ?>>)iregistry, NetherFeatures.CRIMSON_FOREST_VEGETATION_BONEMEAL, worldserver, chunkgenerator, randomsource, blockposition1);
        } else if (iblockdata1.is(Blocks.WARPED_NYLIUM)) {
            this.place((Registry<ConfiguredFeature<?, ?>>)iregistry, NetherFeatures.WARPED_FOREST_VEGETATION_BONEMEAL, worldserver, chunkgenerator, randomsource, blockposition1);
            this.place((Registry<ConfiguredFeature<?, ?>>)iregistry, NetherFeatures.NETHER_SPROUTS_BONEMEAL, worldserver, chunkgenerator, randomsource, blockposition1);
            if (randomsource.nextInt(8) == 0) {
                this.place((Registry<ConfiguredFeature<?, ?>>)iregistry, NetherFeatures.TWISTING_VINES_BONEMEAL, worldserver, chunkgenerator, randomsource, blockposition1);
            }
        }
    }

    private void place(Registry<ConfiguredFeature<?, ?>> iregistry, ResourceKey<ConfiguredFeature<?, ?>> resourcekey, ServerLevel worldserver, ChunkGenerator chunkgenerator, RandomSource randomsource, BlockPos blockposition) {
        iregistry.get(resourcekey).ifPresent(holder_c -> ((ConfiguredFeature)holder_c.value()).place(worldserver, chunkgenerator, randomsource, blockposition));
    }

    @Override
    public BonemealableBlock.Type getType() {
        return BonemealableBlock.Type.NEIGHBOR_SPREADER;
    }
}

